/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.properties;

import epicsquid.roots.properties.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class PropertyTable
implements Iterable<Map.Entry<String, Property<?>>> {
    private final Map<Property<?>, Object> map = new HashMap();
    private final Map<String, Property<?>> reverseMap = new HashMap();
    private final Set<String> fetchedKeys = new HashSet<String>();

    public Collection<Property<?>> getProperties() {
        return this.reverseMap.values();
    }

    public void add(Property<?> ... properties) {
        for (Property<?> prop : properties) {
            this.map.put(prop, null);
            this.reverseMap.put(prop.getName(), prop);
        }
    }

    public <T> T getValue(String propertyName) {
        this.fetchedKeys.add(propertyName);
        Property<?> prop = this.reverseMap.get(propertyName);
        return (T)this.get(prop);
    }

    public <T> Property<T> get(String propertyName) {
        this.fetchedKeys.add(propertyName);
        Property<?> prop = this.reverseMap.get(propertyName);
        if (prop == null) {
            return null;
        }
        return prop;
    }

    public <T> Property<T> get(String propertyName, T value) throws ClassCastException {
        Property<?> prop = this.reverseMap.get(propertyName);
        if (!prop.getType().equals(value.getClass())) {
            throw new ClassCastException("Invalid cast: cannot cast " + prop.getType().getSimpleName() + " into " + value.getClass().getSimpleName());
        }
        return this.get(propertyName);
    }

    public <T> T get(Property<T> property) {
        this.fetchedKeys.add(property.getName());
        Object result = property.cast(this.map.get(property));
        if (result == null && property.hasDefaultValue()) {
            return property.getDefaultValue();
        }
        return result;
    }

    public <T> void set(Property<T> property, T value) {
        if (!property.validate(value)) {
            throw new InvalidPropetyValue("Value " + value + " is not valid for property " + property.getName() + ", bounds: " + property.getValidationBounds());
        }
        this.map.put(property, value);
    }

    public int[] getRadius() {
        int[] radius = this.getRadius("radius");
        if (radius == null) {
            throw new IllegalArgumentException("This property table does not contain radius_x, radius_y and/or radius_z");
        }
        return radius;
    }

    @Nullable
    public int[] getRadius(String radiusPrefix) {
        int z;
        int y;
        int x;
        Property pX = this.get(radiusPrefix + "_x");
        Property pY = this.get(radiusPrefix + "_y");
        Property pZ = this.get(radiusPrefix + "_z");
        if (pX == null || pY == null || pZ == null) {
            return null;
        }
        try {
            x = (Integer)this.get(pX);
            y = (Integer)this.get(pY);
            z = (Integer)this.get(pZ);
        }
        catch (ClassCastException ignored) {
            return null;
        }
        return new int[]{x, y, z};
    }

    public boolean hasProperty(Property<?> property) {
        return this.map.containsKey(property);
    }

    public boolean hasProperty(String prop) {
        return this.reverseMap.containsKey(prop);
    }

    @Override
    public Iterator<Map.Entry<String, Property<?>>> iterator() {
        return this.reverseMap.entrySet().iterator();
    }

    public List<String> finalise() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.reverseMap.keySet()) {
            if (this.fetchedKeys.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public static class InvalidPropetyValue
    extends IllegalArgumentException {
        public InvalidPropetyValue() {
        }

        public InvalidPropetyValue(String s) {
            super(s);
        }

        public InvalidPropetyValue(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidPropetyValue(Throwable cause) {
            super(cause);
        }
    }
}

