/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import epicsquid.mysticallib.types.OneTimeSupplier;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.Roots;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.oredict.OreIngredient;

public class OreChances {
    private static final List<OreItem> items = new ArrayList<OreItem>();

    public static void clear() {
        items.clear();
    }

    public static void addOreChance(OreItem item) {
        items.add(item);
    }

    public static IBlockState getRandomState() {
        if (items.isEmpty()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        OreItem item = (OreItem)WeightedRandom.func_76271_a((Random)Util.rand, items);
        IBlockState state = item.getState();
        if (state == null) {
            for (int tries = 20; tries > 0 && state == null; --tries) {
                state = ((OreItem)WeightedRandom.func_76271_a((Random)Util.rand, items)).getState();
            }
            if (state == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return state;
        }
        return state;
    }

    static {
        OreChances.addOreChance(new OreDictItem("oreGold", 10));
        OreChances.addOreChance(new OreDictItem("oreIron", 40));
        OreChances.addOreChance(new OreDictItem("oreLapis", 12));
        OreChances.addOreChance(new OreDictItem("oreDiamond", 5));
        OreChances.addOreChance(new OreDictItem("oreEmerald", 4));
        OreChances.addOreChance(new OreDictItem("oreRedstone", 22));
        OreChances.addOreChance(new OreDictItem("oreQuartz", 18));
        OreChances.addOreChance(new OreDictItem("oreCoal", 75));
    }

    public static abstract class OreItem
    extends WeightedRandom.Item {
        protected OreItem(int itemWeightIn) {
            super(itemWeightIn);
        }

        @Nullable
        public abstract IBlockState getState();
    }

    public static class OreDictItem
    extends OreItem {
        private final Supplier<Ingredient> ore = new OneTimeSupplier(() -> new OreIngredient(ore));
        private final String name;

        public OreDictItem(String ore, int itemWeightIn) {
            super(itemWeightIn);
            this.name = ore;
        }

        @Override
        @Nullable
        public IBlockState getState() {
            ItemStack stack = this.ore.get().func_193365_a()[0];
            if (stack.func_77973_b() instanceof ItemBlock) {
                Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
                return block.func_176203_a(stack.func_77960_j());
            }
            Roots.logger.error("OreDictItem for " + this.name + " does not contain a usable itemblock.");
            return null;
        }
    }

    public static class StateItem
    extends OreItem {
        private final IBlockState state;

        public StateItem(IBlockState state, int itemWeightIn) {
            super(itemWeightIn);
            this.state = state;
        }

        @Override
        @Nullable
        public IBlockState getState() {
            return this.state;
        }
    }
}

