/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.recipe;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.recipe.IRootsRecipe;
import epicsquid.roots.tileentity.TileEntityPyre;
import epicsquid.roots.util.types.RegistryItem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PyreCraftingRecipe
extends RegistryItem
implements IRootsRecipe<TileEntityPyre> {
    private List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private ItemStack result;
    private String name;
    private int xp;
    private int burnTime;

    public PyreCraftingRecipe(ItemStack result, int xp) {
        this.result = result;
        this.xp = xp;
        this.burnTime = 200;
    }

    public PyreCraftingRecipe(ItemStack result) {
        this(result, 0);
    }

    public PyreCraftingRecipe setName(String name) {
        this.setRegistryName(new ResourceLocation("roots", name));
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PyreCraftingRecipe addIngredient(Ingredient stack) {
        this.ingredients.add(stack);
        return this;
    }

    public PyreCraftingRecipe addIngredient(ItemStack stack) {
        this.ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}));
        return this;
    }

    public PyreCraftingRecipe addIngredients(Object ... stacks) {
        for (Object stack : stacks) {
            if (stack instanceof Ingredient) {
                this.ingredients.add((Ingredient)stack);
                continue;
            }
            if (!(stack instanceof ItemStack)) continue;
            this.ingredients.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)stack}));
        }
        return this;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public PyreCraftingRecipe setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public int getXP() {
        return this.xp;
    }

    @Override
    public List<ItemStack> getRecipe() {
        return this.ingredients.stream().map(ingredient -> ingredient.func_193365_a()[0]).collect(Collectors.toList());
    }

    @Override
    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void postCraft(ItemStack output, IItemHandlerModifiable handler, TileEntityPyre pyre) {
    }

    @Override
    public List<ItemStack> transformIngredients(List<ItemStack> items, TileEntityPyre pyre) {
        return ItemUtil.transformContainers(items);
    }
}

