/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualGroveSupplication;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualGroveSupplication
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(120);
    public static Property.PropertyInterval PROP_INTERVAL = new Property.PropertyInterval(100).setDescription("delay from ritual start until activation of groves");
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 15).setDescription("X range of the ritual");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 10).setDescription("Y range of the ritual");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 15).setDescription("Z range of the ritual");
    public int interval;
    public int radius_x;
    public int radius_y;
    public int radius_z;

    public RitualGroveSupplication(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_INTERVAL, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z);
        this.setEntityClass(EntityRitualGroveSupplication.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new OreIngredient("doorWood"), new ItemStack(Blocks.field_150341_Y), new OreIngredient("treeSapling"), new OreIngredient("wildroot"), new ItemStack(ModItems.petals));
        this.setIcon(ModItems.ritual_grove_supplication);
        this.setColor(TextFormatting.YELLOW);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        this.interval = this.properties.get(PROP_INTERVAL);
        int[] r = this.properties.getRadius();
        this.radius_x = r[0];
        this.radius_y = r[1];
        this.radius_z = r[2];
    }
}

