/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.mysticalworld.init.ModItems;
import epicsquid.roots.entity.ritual.EntityRitualHealingAura;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionRunedPillars;
import epicsquid.roots.util.RitualUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualHealingAura
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(800);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 15).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 15).setDescription("Radius on the Y Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 15).setDescription("Radius on the Z Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_INTERVAL = new Property<Integer>("passive_interval", 40).setDescription("interval in ticks between each ritual healing pulse");
    public static Property.PropertyInterval PROP_PLAYER_INTERVAL = new Property.PropertyInterval(60).setDescription("interval in ticks between each ritual healing pulse specifically for players");
    public static Property<Float> PROP_PLAYER_AMOUNT = new Property<Float>("player_amount", Float.valueOf(1.0f)).setDescription("the amount of life points is healed for players for of each ritual pulse");
    public static Property<Float> PROP_AMOUNT = new Property<Float>("amount", Float.valueOf(4.0f)).setDescription("the amount of life points a non-player entity is healed for each ritual pulse");
    public double radius_x;
    public double radius_y;
    public double radius_z;
    public float amount;
    public float player_amount;
    public int interval;
    public int player_interval;

    public RitualHealingAura(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_INTERVAL, PROP_PLAYER_AMOUNT, PROP_AMOUNT, PROP_PLAYER_INTERVAL);
        this.setEntityClass(EntityRitualHealingAura.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(epicsquid.roots.init.ModItems.terra_moss), new ItemStack(ModItems.aubergine), new ItemStack(epicsquid.roots.init.ModItems.bark_birch), new OreIngredient("wildroot"), new OreIngredient("treeSapling"));
        this.addCondition(new ConditionRunedPillars(RitualUtil.RunedWoodType.BIRCH, 3, 1));
        this.setIcon(epicsquid.roots.init.ModItems.ritual_healing_aura);
        this.setColor(TextFormatting.GOLD);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = (double)radius[0] + 0.5;
        this.radius_y = (double)radius[1] + 0.5;
        this.radius_z = (double)radius[2] + 0.5;
        this.amount = this.properties.get(PROP_AMOUNT).floatValue();
        this.player_amount = this.properties.get(PROP_PLAYER_AMOUNT).floatValue();
        this.interval = this.properties.get(PROP_INTERVAL);
        this.player_interval = this.properties.get(PROP_PLAYER_INTERVAL);
    }
}

