/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualOvergrowth;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualOvergrowth
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(3000);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 10).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 20).setDescription("Radius on the Y Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 10).setDescription("Radius on the Z Axis of the cube in which the ritual takes place");
    public static Property.PropertyInterval PROP_INTERVAL = new Property.PropertyInterval(100).setDescription("interval in ticks between each mossy cobblestone generated");
    public int radius_x;
    public int radius_y;
    public int radius_z;
    public int interval;

    public RitualOvergrowth(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_INTERVAL);
        this.setEntityClass(EntityRitualOvergrowth.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new OreIngredient("sugarcane"), new ItemStack(ModItems.terra_moss), new OreIngredient("tallgrass"), new OreIngredient("rootsBark"), new OreIngredient("rootsBark"));
        this.setIcon(ModItems.ritual_overgrowth);
        this.setColor(TextFormatting.DARK_GREEN);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = radius[0];
        this.radius_y = radius[1];
        this.radius_z = radius[2];
        this.interval = this.properties.get(PROP_INTERVAL);
    }
}

