/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.config.RitualConfig;
import epicsquid.roots.ritual.RitualAnimalHarvest;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualDivineProtection;
import epicsquid.roots.ritual.RitualFireStorm;
import epicsquid.roots.ritual.RitualFlowerGrowth;
import epicsquid.roots.ritual.RitualFrostLands;
import epicsquid.roots.ritual.RitualGathering;
import epicsquid.roots.ritual.RitualGermination;
import epicsquid.roots.ritual.RitualGroveSupplication;
import epicsquid.roots.ritual.RitualHealingAura;
import epicsquid.roots.ritual.RitualHeavyStorms;
import epicsquid.roots.ritual.RitualOvergrowth;
import epicsquid.roots.ritual.RitualPurity;
import epicsquid.roots.ritual.RitualSpreadingForest;
import epicsquid.roots.ritual.RitualSummonCreatures;
import epicsquid.roots.ritual.RitualTransmutation;
import epicsquid.roots.ritual.RitualWardingProtection;
import epicsquid.roots.ritual.RitualWildrootGrowth;
import epicsquid.roots.ritual.RitualWindwall;
import epicsquid.roots.tileentity.TileEntityPyre;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class RitualRegistry {
    public static Map<String, RitualBase> ritualRegistry = new HashMap<String, RitualBase>();
    public static RitualBase ritual_healing_aura;
    public static RitualBase ritual_heavy_storms;
    public static RitualBase ritual_divine_protection;
    public static RitualBase ritual_fire_storm;
    public static RitualBase ritual_spreading_forest;
    public static RitualBase ritual_windwall;
    public static RitualBase ritual_warding_protection;
    public static RitualBase ritual_germination;
    public static RitualBase ritual_purity;
    public static RitualBase ritual_frost_lands;
    public static RitualBase ritual_animal_harvest;
    public static RitualBase ritual_summon_creatures;
    public static RitualBase ritual_wildroot_growth;
    public static RitualBase ritual_overgrowth;
    public static RitualBase ritual_flower_growth;
    public static RitualBase ritual_transmutation;
    public static RitualBase ritual_gathering;
    public static RitualBase ritual_grove_supplication;

    public static RitualBase getRitual(TileEntityPyre tileEntity, @Nullable EntityPlayer player) {
        for (int i = 0; i < ritualRegistry.size(); ++i) {
            RitualBase ritual = ritualRegistry.values().toArray(new RitualBase[0])[i];
            if (!ritual.isRitualRecipe(tileEntity, player)) continue;
            return ritual;
        }
        return null;
    }

    public static RitualBase getRitual(String ritualName) {
        if (ritualName == null) {
            return null;
        }
        if (!ritualName.startsWith("ritual_")) {
            ritualName = "ritual_" + ritualName;
        }
        for (RitualBase ritual : ritualRegistry.values()) {
            if (!ritual.getName().equalsIgnoreCase(ritualName)) continue;
            return ritual;
        }
        return null;
    }

    public static void preInit() {
        ritual_animal_harvest = new RitualAnimalHarvest("ritual_animal_harvest", RitualConfig.disableRitualCategory.disableAnimalHarvest);
        RitualRegistry.addRitual(ritual_animal_harvest);
        ritual_divine_protection = new RitualDivineProtection("ritual_divine_protection", RitualConfig.disableRitualCategory.disableDivineProtection);
        RitualRegistry.addRitual(ritual_divine_protection);
        ritual_fire_storm = new RitualFireStorm("ritual_fire_storm", RitualConfig.disableRitualCategory.disableFireStorm);
        RitualRegistry.addRitual(ritual_fire_storm);
        ritual_flower_growth = new RitualFlowerGrowth("ritual_flower_growth", RitualConfig.disableRitualCategory.disableFlowerGrowth);
        RitualRegistry.addRitual(ritual_flower_growth);
        ritual_frost_lands = new RitualFrostLands("ritual_frost_lands", RitualConfig.disableRitualCategory.disableFrostLands);
        RitualRegistry.addRitual(ritual_frost_lands);
        ritual_gathering = new RitualGathering("ritual_gathering", RitualConfig.disableRitualCategory.disableGathering);
        RitualRegistry.addRitual(ritual_gathering);
        ritual_germination = new RitualGermination("ritual_germination", RitualConfig.disableRitualCategory.disableNaturalAura);
        RitualRegistry.addRitual(ritual_germination);
        ritual_healing_aura = new RitualHealingAura("ritual_healing_aura", RitualConfig.disableRitualCategory.disableHealingAura);
        RitualRegistry.addRitual(ritual_healing_aura);
        ritual_heavy_storms = new RitualHeavyStorms("ritual_heavy_storms", RitualConfig.disableRitualCategory.disableHeavyStorms);
        RitualRegistry.addRitual(ritual_heavy_storms);
        ritual_overgrowth = new RitualOvergrowth("ritual_overgrowth", RitualConfig.disableRitualCategory.disableOvergrowth);
        RitualRegistry.addRitual(ritual_overgrowth);
        ritual_purity = new RitualPurity("ritual_purity", RitualConfig.disableRitualCategory.disablePurity);
        RitualRegistry.addRitual(ritual_purity);
        ritual_spreading_forest = new RitualSpreadingForest("ritual_spreading_forest", RitualConfig.disableRitualCategory.disableNaturalGrowth);
        RitualRegistry.addRitual(ritual_spreading_forest);
        ritual_summon_creatures = new RitualSummonCreatures("ritual_summon_creatures", RitualConfig.disableRitualCategory.disableSummonCreatures);
        RitualRegistry.addRitual(ritual_summon_creatures);
        ritual_transmutation = new RitualTransmutation("ritual_transmutation", RitualConfig.disableRitualCategory.disableTransmutation);
        RitualRegistry.addRitual(ritual_transmutation);
        ritual_warding_protection = new RitualWardingProtection("ritual_warding_protection", RitualConfig.disableRitualCategory.disableWardingProtection);
        RitualRegistry.addRitual(ritual_warding_protection);
        ritual_wildroot_growth = new RitualWildrootGrowth("ritual_wildroot_growth", RitualConfig.disableRitualCategory.disableWildGrowth);
        RitualRegistry.addRitual(ritual_wildroot_growth);
        ritual_windwall = new RitualWindwall("ritual_windwall", RitualConfig.disableRitualCategory.disableWindwall);
        RitualRegistry.addRitual(ritual_windwall);
        ritual_grove_supplication = new RitualGroveSupplication("ritual_grove_supplication", false);
        RitualRegistry.addRitual(ritual_grove_supplication);
    }

    public static void init() {
        ritualRegistry.values().forEach(RitualBase::init);
    }

    public static void addRitual(RitualBase ritual) {
        ritualRegistry.put(ritual.getName(), ritual);
    }

    public static void finalise() {
        ritualRegistry.values().forEach(RitualBase::finalise);
    }

    public static Collection<RitualBase> getRituals() {
        return ritualRegistry.values();
    }
}

