/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.entity.ritual.EntityRitualSummonCreatures;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.properties.Property;
import epicsquid.roots.recipe.SummonCreatureRecipe;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionValidSummon;
import epicsquid.roots.tileentity.TileEntityCatalystPlate;
import epicsquid.roots.util.RitualUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreIngredient;

public class RitualSummonCreatures
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(200);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 3).setDescription("Radius on the X Axis of the square area in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 5).setDescription("Radius on the Y Axis of the square area in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 3).setDescription("Radius on the Z Axis of the square area in which the ritual takes place");
    public static Property.PropertyInterval PROP_INTERVAL = new Property.PropertyInterval(150).setDescription("interval in ticks between each summoned creature");
    public static Property<Integer> PROP_TRIES = new Property<Integer>("tries", 10).setDescription("number of attempts at finding a random good (satisfying the conditions) position to spawn the creature");
    public static Property<Integer> PROP_GLOW_DURATION = new Property<Integer>("glow_duration", 30).setDescription("the duration at which newly spawned and summoned entities will glow at (in ticks)");
    public int radius_x;
    public int radius_y;
    public int radius_z;
    public int tries;
    public int interval;
    public int glow_duration;

    public RitualSummonCreatures(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_INTERVAL, PROP_TRIES, PROP_GLOW_DURATION);
        this.setEntityClass(EntityRitualSummonCreatures.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(Items.field_151014_N), new OreIngredient("cropWheat"), new OreIngredient("egg"), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151014_N));
        this.addCondition(new ConditionValidSummon());
        this.setIcon(ModItems.ritual_summon_creatures);
        this.setColor(TextFormatting.DARK_PURPLE);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        this.radius_x = this.properties.get(PROP_RADIUS_X);
        this.radius_z = this.properties.get(PROP_RADIUS_Z);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.interval = this.properties.get(PROP_INTERVAL);
        this.tries = this.properties.get(PROP_TRIES);
        this.glow_duration = this.properties.get(PROP_GLOW_DURATION);
    }

    @Override
    public EntityRitualBase doEffect(World world, BlockPos pos, @Nullable EntityPlayer player) {
        EntityRitualSummonCreatures entity = (EntityRitualSummonCreatures)this.spawnEntity(world, pos, EntityRitualSummonCreatures.class, player);
        if (!world.field_72995_K) {
            List<TileEntityCatalystPlate> plates = RitualUtil.getNearbyCatalystPlates(world, pos);
            List<ItemStack> plateItems = RitualUtil.getItemsFromNearbyPlates(plates);
            SummonCreatureRecipe recipe = ModRecipes.findSummonCreatureEntry(plateItems);
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            if (recipe != null) {
                for (TileEntityCatalystPlate plate : plates) {
                    ingredients.add(plate.removeItem());
                }
            }
            ItemStack essence = ItemStack.field_190927_a;
            if (recipe == null) {
                for (TileEntityCatalystPlate plate : plates) {
                    ItemStack stack = plate.getHeldItem();
                    if (stack.func_77973_b() != ModItems.life_essence) continue;
                    essence = stack;
                    plate.removeItem();
                    break;
                }
            }
            if (!ingredients.isEmpty()) {
                for (ItemStack stack : recipe.transformIngredients(ingredients, null)) {
                    ItemUtil.spawnItem((World)world, (BlockPos)pos.func_177982_a(random.nextBoolean() ? -1 : 1, 1, random.nextBoolean() ? -1 : 1), (ItemStack)stack);
                }
            }
            if (entity != null) {
                entity.setEssence(essence);
                entity.setSummonRecipe(recipe);
            }
        }
        return entity;
    }
}

