/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.mechanics.Growth;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageDesaturationFX;
import epicsquid.roots.network.fx.MessageRampantLifeInfusionFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreIngredient;

public class SpellDesaturate
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(500);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("spirit_herb", 0.5));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("terra_moss", 0.5));
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 8).setDescription("radius on the X axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 2).setDescription("radius on the Y axis within which entities are affected by the spell");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 8).setDescription("radius on the Z axis within which entities are affected by the spell");
    public static Property<Double> PROP_MULTIPLIER = new Property<Double>("multiplier", 0.7).setDescription("amount of health points restored by each food point");
    public static Property<Double> PROP_AMPLIFIED_MULTIPLIER = new Property<Double>("amplified_multiplier", 0.95).setDescription("amount of health points restored by each food point when using the amplified bonus");
    public static Property<Integer> PROP_SHIELD_BASE = new Property<Integer>("shield_base_duration", 20).setDescription("the base duration for the shield, multiplied by overflow");
    public static Property<Integer> PROP_SHIELD_AMPLIFIER = new Property<Integer>("shield_amplifier", 0).setDescription("the amplifier value for the shield");
    public static Property<Integer> PROP_RESISTANCE_BASE = new Property<Integer>("resistance_base_duration", 20).setDescription("the base duration for the resistance buff, multiplied by overflow");
    public static Property<Integer> PROP_RESISTANCE_AMPLIFIER = new Property<Integer>("resistance_amplifier", 0).setDescription("the amplifier value for the resistance buff");
    public static Property<Integer> PROP_GROWTH_TICKS = new Property<Integer>("growth_ticks", 10).setDescription("the number of additional growth ticks to apply multiplied by overflow");
    public static Property<Integer> PROP_GROWTH_COUNT = new Property<Integer>("growth_count", 3).setDescription("the number of random plants that should be considered for growth");
    public static Property<Integer> PROP_HEAL_AMOUNT = new Property<Integer>("heal_targets", 3).setDescription("the number of peaceful creatures nearby that should be healed");
    public static Property<Integer> PROP_DAMAGE_AMOUNT = new Property<Integer>("damage_targets", 4).setDescription("the number of hostile creatures nearby that should be damaged");
    public static Property<Integer> PROP_LEVITATION_DURATION = new Property<Integer>("levitation_duration", 20).setDescription("the duration of the levitation effect multiplied by the overflow");
    public static Property<Integer> PROP_LEVITATE_TARGETS = new Property<Integer>("levitation_targets", 3).setDescription("the number of hostile nearby creatures that should be levitated");
    public static Modifier RATIO = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "amplified_saturation"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.6)));
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "excess_heal"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier GROWTH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "excess_growth"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.125)));
    public static Modifier SHIELD = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "excess_absorb"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.45)));
    public static Modifier DAMAGE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "excess_damage"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.65)));
    public static Modifier LEVITATE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "excess_levitation"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.275)));
    public static Modifier THOUGHTFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "thoughtful"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.3)));
    public static Modifier RESISTANCE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "excess_stone_skin"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.4)));
    public static Modifier PURIFY = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "excess_purification"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.7)));
    public static ResourceLocation spellName;
    public static SpellDesaturate instance;
    private AxisAlignedBB box;
    private double multiplier;
    private double amplified_multiplier;
    private int shield_base;
    private int shield_amplifier;
    private int resistance_base;
    private int resistance_amplifier;
    private int growth_ticks;
    private int growth_count;
    private int heal_amount;
    private int damage_amount;
    private int levitation_duration;
    private int levitation_targets;
    private int radius_x;
    private int radius_y;
    private int radius_z;

    public SpellDesaturate(ResourceLocation name) {
        super(name, TextFormatting.DARK_PURPLE, 0.72156864f, 0.9098039f, 0.16470589f, 0.42745098f, 0.1254902f, 0.65882355f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_MULTIPLIER, PROP_AMPLIFIED_MULTIPLIER, PROP_SHIELD_BASE, PROP_SHIELD_AMPLIFIER, PROP_LEVITATE_TARGETS, PROP_LEVITATION_DURATION, PROP_RESISTANCE_AMPLIFIER, PROP_RESISTANCE_BASE, PROP_GROWTH_COUNT, PROP_GROWTH_TICKS, PROP_HEAL_AMOUNT, PROP_DAMAGE_AMOUNT, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z);
        this.acceptModifiers(RATIO, PEACEFUL, GROWTH, SHIELD, DAMAGE, LEVITATE, THOUGHTFUL, RESISTANCE, PURIFY);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Items.field_151054_z), new ItemStack(ModItems.petals), new ItemStack(Items.field_151078_bh), new OreIngredient("bone"), new ItemStack(ModItems.spirit_herb));
        this.setCastSound(ModSounds.Spells.DESATURATE);
    }

    @Override
    public boolean cast(EntityPlayer caster, StaffModifierInstanceList info, int ticks) {
        if (!caster.func_70996_bM()) {
            return false;
        }
        FoodStats stats = caster.func_71024_bL();
        int food = stats.func_75116_a();
        if (food <= 1) {
            return false;
        }
        double multiplier = this.multiplier;
        if (info.has(RATIO)) {
            multiplier = this.amplified_multiplier;
        }
        multiplier = (float)multiplier;
        float missing = caster.func_110138_aP() - caster.func_110143_aJ();
        float healed = 0.0f;
        float required = info.has(THOUGHTFUL) ? caster.func_110138_aP() - caster.func_110143_aJ() : caster.func_110138_aP();
        int i = 0;
        while ((float)i <= required && food > 1) {
            --food;
            healed = (float)((double)healed + 1.0 * multiplier);
            ++i;
        }
        float overheal = (float)Math.floor((healed - missing) * 10.0f) / 10.0f;
        World world = caster.field_70170_p;
        if (!world.field_72995_K) {
            caster.func_70691_i(healed);
            stats.func_75114_a(food);
            stats.field_75125_b = Math.min(stats.field_75125_b, (float)food);
            if (!info.has(THOUGHTFUL) && overheal > 0.0f) {
                List entities;
                if (info.has(PEACEFUL)) {
                    entities = caster.field_70170_p.func_175647_a(EntityLivingBase.class, this.box.func_186670_a(caster.func_180425_c()), o -> EntityUtil.isFriendly((Entity)o, instance));
                    for (int count = 0; entities.size() > 0 && count < this.heal_amount; ++count) {
                        int targ = Util.rand.nextInt(entities.size());
                        EntityLivingBase target = (EntityLivingBase)entities.remove(targ);
                        target.func_70691_i(overheal);
                    }
                } else if (info.has(GROWTH)) {
                    List<BlockPos> positions = Growth.collect(caster.field_70170_p, caster.func_180425_c(), this.radius_x, this.radius_y, this.radius_z);
                    for (int count = 0; positions.size() > 0 && count < this.growth_count; ++count) {
                        int targ = Util.rand.nextInt(positions.size());
                        BlockPos pos = positions.remove(targ);
                        int i2 = 0;
                        while ((float)i2 < (float)this.growth_ticks * overheal) {
                            IBlockState state = caster.field_70170_p.func_180495_p(pos);
                            state.func_177230_c().func_180645_a(caster.field_70170_p, pos, state, Util.rand);
                            ++i2;
                        }
                        PacketHandler.sendToAllTracking((IMessage)new MessageRampantLifeInfusionFX(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), (Entity)caster);
                    }
                } else if (info.has(SHIELD)) {
                    caster.func_70690_d(new PotionEffect(MobEffects.field_76444_x, (int)((float)this.shield_base * overheal), this.shield_amplifier, false, false));
                } else if (info.has(DAMAGE)) {
                    entities = caster.field_70170_p.func_175647_a(EntityLivingBase.class, this.box.func_186670_a(caster.func_180425_c()), o -> EntityUtil.isHostile((Entity)o, instance));
                    for (int count = 0; entities.size() > 0 && count < this.damage_amount; ++count) {
                        int targ = Util.rand.nextInt(entities.size());
                        EntityLivingBase target = (EntityLivingBase)entities.remove(targ);
                        target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)caster), overheal);
                    }
                } else if (info.has(LEVITATE)) {
                    entities = caster.field_70170_p.func_175647_a(EntityLivingBase.class, this.box.func_186670_a(caster.func_180425_c()), o -> EntityUtil.isHostile((Entity)o, instance));
                    for (int count = 0; entities.size() > 0 && count < this.levitation_targets; ++count) {
                        int targ = Util.rand.nextInt(entities.size());
                        EntityLivingBase target = (EntityLivingBase)entities.remove(targ);
                        target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, (int)((float)this.levitation_duration * overheal), 0));
                    }
                } else if (info.has(RESISTANCE)) {
                    caster.func_70690_d(new PotionEffect(MobEffects.field_76429_m, (int)((float)this.resistance_base * overheal), this.resistance_amplifier, false, false));
                } else if (info.has(PURIFY)) {
                    ArrayList<Potion> effects = new ArrayList<Potion>();
                    int c = (int)Math.floor(overheal) + 1;
                    for (PotionEffect ef : caster.func_70651_bq()) {
                        Potion pot;
                        if (!ef.func_188419_a().func_76398_f() || (pot = ef.func_188419_a()) == null) continue;
                        effects.add(pot);
                        if (--c > 0) continue;
                        break;
                    }
                    for (Potion pot : effects) {
                        caster.func_184589_d(pot);
                    }
                }
            }
            ((EntityPlayerMP)caster).field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(caster.func_110143_aJ(), stats.func_75116_a(), stats.func_75115_e()));
            MessageDesaturationFX message = new MessageDesaturationFX(caster);
            PacketHandler.sendToAllTracking((IMessage)message, (Entity)caster);
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.multiplier = this.properties.get(PROP_MULTIPLIER);
        this.amplified_multiplier = this.properties.get(PROP_AMPLIFIED_MULTIPLIER);
        this.shield_base = this.properties.get(PROP_SHIELD_BASE);
        this.shield_amplifier = this.properties.get(PROP_SHIELD_AMPLIFIER);
        this.resistance_base = this.properties.get(PROP_RESISTANCE_BASE);
        this.resistance_amplifier = this.properties.get(PROP_RESISTANCE_AMPLIFIER);
        this.growth_ticks = this.properties.get(PROP_GROWTH_TICKS);
        this.growth_count = this.properties.get(PROP_GROWTH_COUNT);
        this.heal_amount = this.properties.get(PROP_HEAL_AMOUNT);
        this.damage_amount = this.properties.get(PROP_DAMAGE_AMOUNT);
        this.levitation_duration = this.properties.get(PROP_LEVITATION_DURATION);
        this.levitation_targets = this.properties.get(PROP_LEVITATE_TARGETS);
        int[] radius = this.properties.getRadius();
        this.radius_x = radius[0];
        this.radius_y = radius[1];
        this.radius_z = radius[2];
        this.box = new AxisAlignedBB((double)(-this.radius_x), (double)(-this.radius_y), (double)(-this.radius_z), (double)(this.radius_x + 1), (double)(this.radius_y + 1), (double)(this.radius_z + 1));
    }

    static {
        THOUGHTFUL.addConflicts(PEACEFUL, GROWTH, SHIELD, DAMAGE, LEVITATE, RESISTANCE, PURIFY);
        PEACEFUL.addConflicts(GROWTH, SHIELD, DAMAGE, LEVITATE, RESISTANCE, PURIFY);
        GROWTH.addConflicts(SHIELD, DAMAGE, LEVITATE, RESISTANCE, PURIFY);
        SHIELD.addConflicts(LEVITATE, RESISTANCE, PURIFY);
        LEVITATE.addConflicts(RESISTANCE, PURIFY);
        RESISTANCE.addConflict(PURIFY);
        spellName = new ResourceLocation("roots", "spell_desaturate");
        instance = new SpellDesaturate(spellName);
    }
}

