/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityUtil;
import epicsquid.roots.util.SlaveUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;

public class SpellGeas
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(80);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("baffle_cap", 0.45));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("terra_moss", 0.125));
    public static Property<Integer> PROP_DURATION = new Property<Integer>("geas_duration", 400).setDescription("duration in ticks of this spell effect on entities");
    public static Property<Integer> PROP_EXTENSION = new Property<Integer>("extension", 600).setDescription("additional duration in ticks to be added to the base duration");
    public static Property<Integer> PROP_WEAKNESS_DURATION = new Property<Integer>("weakness_duration", 80).setDescription("how long the creature should be weakened for after geas ends");
    public static Property<Float> PROP_FIRE_DAMAGE = new Property<Float>("fire_damage", Float.valueOf(2.5f)).setDescription("the amount of fire damage that creatures should take after the geas ends");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 3).setDescription("how long creatures should be set on fire for after geas ends");
    public static Property<Float> PROP_PHYSICAL_DAMAGE = new Property<Float>("physical_damage", Float.valueOf(2.5f)).setDescription("the amount of physical damage creatures should take after the geas ends");
    public static Property<Float> PROP_WATER_DAMAGE = new Property<Float>("water_damage", Float.valueOf(2.5f)).setDescription("how much water damage creatures should take after the geas ends");
    public static Property<Integer> PROP_WEAKNESS_AMPLIFIER = new Property<Integer>("weakness_amplifier", 0).setDescription("the amplifier to be applied to the weakness effect");
    public static Property<Integer> PROP_SAVIOR_DURATION = new Property<Integer>("savior_duration", 200).setDescription("the duration of the absorption effect to be applied to peaceful entities");
    public static Property<Integer> PROP_SAVIOR_AMPLIFIER = new Property<Integer>("savior_amplifier", 3).setDescription("the amplifier of the absorption effect to be applied to peaceful entities");
    public static Modifier DURATION = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "extended_geas"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.45)));
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "animal_savior"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 1.0)));
    public static Modifier WEAKNESS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "weakened_response"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.275)));
    public static Modifier GUARDIANS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "unholy_command"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.675)));
    public static Modifier ADDED1 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "additional_target1"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.675)));
    public static Modifier ADDED2 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "additional_target2"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.675)));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "inferno"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.275)));
    public static Modifier PHYSICAL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "avalanche"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.275)));
    public static Modifier WATER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "waterfall"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.275)));
    public static ResourceLocation spellName;
    public static SpellGeas instance;
    public int weakness_duration;
    public int fire_duration;
    public int weakness_amplifier;
    public int savior_duration;
    public int savior_amplifier;
    public float fire_damage;
    public float physical_damage;
    public float water_damage;
    private int duration;
    private int extension;
    public double distance;

    public SpellGeas(ResourceLocation name) {
        super(name, TextFormatting.DARK_RED, 0.5019608f, 0.1254902f, 0.1254902f, 0.1254902f, 0.1254902f, 0.1254902f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_COST_2, PROP_DURATION, PROP_EXTENSION, PROP_WEAKNESS_DURATION, PROP_FIRE_DAMAGE, PROP_FIRE_DURATION, PROP_PHYSICAL_DAMAGE, PROP_WATER_DAMAGE, PROP_WEAKNESS_AMPLIFIER, PROP_SAVIOR_AMPLIFIER, PROP_SAVIOR_DURATION);
        this.acceptModifiers(DURATION, PEACEFUL, WEAKNESS, GUARDIANS, ADDED1, ADDED2, FIRE, PHYSICAL, WATER);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151058_ca), new ItemStack((Item)Items.field_151112_aM), new ItemStack(ModItems.terra_spores), new ItemStack(Item.func_150898_a((Block)ModBlocks.baffle_cap_mushroom)));
        this.setCastSound(ModSounds.Spells.GEAS);
    }

    private int affect(EntityLivingBase e, EntityPlayer player, StaffModifierInstanceList info, int dur) {
        if (e.func_70660_b(ModPotions.geas) == null) {
            if (EntityUtil.isBoss(e)) {
                return 0;
            }
            if (EntityUtil.isHostileTo((Entity)e, player, instance)) {
                if (!player.field_70170_p.field_72995_K) {
                    if (info.has(GUARDIANS) && SlaveUtil.canBecomeSlave((Entity)e)) {
                        EntityLivingBase slave = SlaveUtil.enslave(e);
                        e.field_70170_p.func_72838_d((Entity)slave);
                        e.func_184174_b(false);
                        e.func_70106_y();
                        slave.func_70634_a(slave.field_70165_t, slave.field_70163_u, slave.field_70161_v);
                        slave.getEntityData().func_74783_a(this.getCachedName(), info.toArray());
                        slave.func_70690_d(new PotionEffect(ModPotions.geas, dur, 0, false, false));
                    } else {
                        e.getEntityData().func_74783_a(this.getCachedName(), info.toArray());
                        e.func_70690_d(new PotionEffect(ModPotions.geas, dur, 0, false, false));
                        if (e instanceof EntityLiving) {
                            ((EntityLiving)e).func_70624_b(null);
                        }
                    }
                }
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        int count = 1;
        int affected = 0;
        int dur = this.duration;
        if (info.has(DURATION)) {
            dur += this.extension;
        }
        boolean peaceful = info.has(PEACEFUL);
        if (info.has(ADDED2)) {
            ++count;
        }
        if (info.has(ADDED1)) {
            ++count;
        }
        block0: for (int i = 0; i < 20; ++i) {
            double x = player.field_70165_t + player.func_70040_Z().field_72450_a * 3.0 * (double)i;
            double y = player.field_70163_u + (double)player.func_70047_e() + player.func_70040_Z().field_72448_b * 3.0 * (double)i;
            double z = player.field_70161_v + player.func_70040_Z().field_72449_c * 3.0 * (double)i;
            List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(x - 4.0, y - 4.0, z - 4.0, x + 5.0, y + 5.0, z + 5.0));
            if (peaceful) {
                for (EntityLivingBase e : entities) {
                    if (!EntityUtil.isFriendlyTo((Entity)e, player, instance)) continue;
                    e.func_70690_d(new PotionEffect(MobEffects.field_76444_x, this.savior_duration, this.savior_amplifier));
                }
            }
            for (EntityLivingBase e : entities) {
                if (affected == count) continue block0;
                if (e == player) continue;
                affected += this.affect(e, player, info, dur);
            }
        }
        return affected > 0;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.duration = this.properties.get(PROP_DURATION);
        this.extension = this.properties.get(PROP_EXTENSION);
        this.weakness_duration = this.properties.get(PROP_WEAKNESS_DURATION);
        this.weakness_amplifier = this.properties.get(PROP_WEAKNESS_AMPLIFIER);
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
        this.fire_damage = this.properties.get(PROP_FIRE_DAMAGE).floatValue();
        this.physical_damage = this.properties.get(PROP_PHYSICAL_DAMAGE).floatValue();
        this.water_damage = this.properties.get(PROP_WATER_DAMAGE).floatValue();
        this.savior_duration = this.properties.get(PROP_SAVIOR_DURATION);
        this.savior_amplifier = this.properties.get(PROP_SAVIOR_AMPLIFIER);
    }

    static {
        FIRE.addConflicts(PHYSICAL, WATER);
        PHYSICAL.addConflicts(WATER);
        spellName = new ResourceLocation("roots", "spell_geas");
        instance = new SpellGeas(spellName);
    }
}

