/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessagePetalShellBurstFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.EntityUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellPetalShell
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(120);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("spirit_herb", 0.75));
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(2400);
    public static Property<Integer> PROP_MAXIMUM = new Property<Integer>("maximum_shells", 3).setDescription("maximum number of shells (attack blockers) a player can have");
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 5).setDescription("radius on the X axis of the area the spell has effect on");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 5).setDescription("radius on the Y axis of the area the spell has effect on");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 5).setDescription("radius on the Z axis of the area the spell has effect on");
    public static Property<Integer> PROP_EXTRA = new Property<Integer>("extra_shells", 2).setDescription("the number of additional extra shells that should be granted");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 5).setDescription("the duration of time at which a person should be set on fire");
    public static Property<Float> PROP_FIRE_DAMAGE = new Property<Float>("fire_damage", Float.valueOf(2.5f)).setDescription("the amount of fire damage that should be done to a creature");
    public static Property<Integer> PROP_POISON_DURATION = new Property<Integer>("poison_duration", 80).setDescription("the duration of the poison effect made by the reactant");
    public static Property<Integer> PROP_POISON_AMPLIFIER = new Property<Integer>("poison_amplifier", 0).setDescription("the amplifier of the poison effect made by the reactant");
    public static Property<Integer> PROP_LEVITATE_DURATION = new Property<Integer>("levitate_duration", 120).setDescription("the duration of the levitation effect applied to creatures");
    public static Property<Integer> PROP_WEAKNESS_DURATION = new Property<Integer>("weakness_duration", 60).setDescription("how long creatures should be weakened for");
    public static Property<Integer> PROP_SLOW_DURATION = new Property<Integer>("slow_duration", 160).setDescription("the duration of time that the slow effect should be applied for to creatures");
    public static Property<Integer> PROP_SLOW_AMPLIFIER = new Property<Integer>("slow_amplifier", 0).setDescription("the amplifier applied to the slow effect");
    public static Property<Float> PROP_DAGGER_DAMAGE = new Property<Float>("dagger_damage", Float.valueOf(2.5f)).setDescription("the amount of slashing damage that should be done to creatures");
    public static Property<Integer> PROP_BLEED_DURATION = new Property<Integer>("bleed_duration", 80).setDescription("the duration of the bleed effect created by the slashing damage");
    public static Property<Integer> PROP_BLEED_AMPLIFIER = new Property<Integer>("bleed_amplifier", 0).setDescription("the amplifier applied to the bleed effect created by the slashing damage");
    public static Property<Float> PROP_RADIANT_DAMAGE = new Property<Float>("radiant_damage", Float.valueOf(2.5f)).setDescription("the amount of radiant damage applied to the attacking creature");
    public static Property<Integer> PROP_WEAKNESS_AMPLIFIER = new Property<Integer>("weakness_amplifier", 0).setDescription("the amplifier to be applied to the weakness effect");
    public static Modifier RADIANT = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "react_radiance"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.375)));
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "peaceful_dance"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.45)));
    public static Modifier SLASHING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "react_daggers"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.375)));
    public static Modifier CHARGES = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "petal_overflow"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.75)));
    public static Modifier COLOUR = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "mossy_leaves"), ModifierCores.TERRA_MOSS, Cost.of(Cost.cost(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.125), Cost.cost(CostType.ALL_COST_MULTIPLIER, -0.15))));
    public static Modifier POISON = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "react_poison"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.375)));
    public static Modifier LEVITATE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "react_drift"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.375)));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "react_fire"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.375)));
    public static Modifier WEAKNESS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "react_weakness"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.375)));
    public static Modifier SLOW = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "react_slow"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.375)));
    public static final float[] mossFirst = new float[]{0.5411765f, 0.6039216f, 0.35686275f, 0.5f};
    public static final float[] mossSecond = new float[]{0.30980393f, 0.3647059f, 0.13725491f, 0.5f};
    public static ResourceLocation spellName;
    public static SpellPetalShell instance;
    public int duration;
    public int fire_duration;
    public int poison_duration;
    public int poison_amplifier;
    public int levitate_duration;
    public int weakness_duration;
    public int slow_duration;
    public int slow_amplifier;
    public int bleed_duration;
    public int bleed_amplifier;
    public int weakness_amplifier;
    public float fire_damage;
    public float dagger_damage;
    public float radiant_damage;
    public int maxShells;
    public int extraShells;
    private int radius_x;
    private int radius_y;
    private int radius_z;
    private AxisAlignedBB bb;

    public SpellPetalShell(ResourceLocation name) {
        super(name, TextFormatting.LIGHT_PURPLE, 1.0f, 0.7529412f, 0.9411765f, 1.0f, 1.0f, 1.0f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_MAXIMUM, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_EXTRA, PROP_FIRE_DURATION, PROP_FIRE_DAMAGE, PROP_POISON_AMPLIFIER, PROP_POISON_DURATION, PROP_LEVITATE_DURATION, PROP_WEAKNESS_DURATION, PROP_SLOW_AMPLIFIER, PROP_SLOW_DURATION, PROP_DAGGER_DAMAGE, PROP_BLEED_AMPLIFIER, PROP_BLEED_DURATION, PROP_RADIANT_DAMAGE, PROP_WEAKNESS_AMPLIFIER);
        this.acceptModifiers(RADIANT, PEACEFUL, SLASHING, CHARGES, COLOUR, POISON, LEVITATE, FIRE, WEAKNESS, SLOW);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(ModItems.petals), new ItemStack(epicsquid.mysticalworld.init.ModItems.aubergine), new ItemStack(ModItems.spirit_herb), new ItemStack(Items.field_185159_cQ), new ItemStack(ModItems.pereskia));
        this.setCastSound(ModSounds.Spells.PETAL_SHELL);
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            int shells = this.maxShells;
            if (info.has(CHARGES)) {
                shells += this.extraShells;
            }
            if (info.has(PEACEFUL)) {
                World world = player.field_70170_p;
                List entities = world.func_72872_a(EntityLivingBase.class, this.bb.func_186670_a(player.func_180425_c()));
                entities.removeIf(o -> !EntityUtil.isFamiliar(player, (Entity)o));
                if (!entities.isEmpty()) {
                    EntityLivingBase entity = (EntityLivingBase)entities.get(Util.rand.nextInt(entities.size()));
                    entity.getEntityData().func_74783_a(this.getCachedName(), info.toArray());
                    PotionEffect effect = entity.func_70660_b(ModPotions.petal_shell);
                    if (effect != null) {
                        entity.func_70690_d(new PotionEffect(ModPotions.petal_shell, this.duration, shells, false, false));
                    } else {
                        entity.func_70690_d(new PotionEffect(ModPotions.petal_shell, this.duration, this.maxShells, false, false));
                    }
                    PacketHandler.sendToAllTracking((IMessage)new MessagePetalShellBurstFX(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v, info), (Entity)entity);
                }
            }
            player.getEntityData().func_74783_a(this.getCachedName(), info.toArray());
            PotionEffect effect = player.func_70660_b(ModPotions.petal_shell);
            if (effect != null) {
                player.func_70690_d(new PotionEffect(ModPotions.petal_shell, this.duration, shells, false, false));
            } else {
                player.func_70690_d(new PotionEffect(ModPotions.petal_shell, this.duration, this.maxShells, false, false));
            }
            PacketHandler.sendToAllTracking((IMessage)new MessagePetalShellBurstFX(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, info), (Entity)player);
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.maxShells = this.properties.get(PROP_MAXIMUM);
        this.duration = this.properties.get(PROP_DURATION);
        this.radius_x = this.properties.get(PROP_RADIUS_X);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.radius_z = this.properties.get(PROP_RADIUS_Z);
        this.bb = new AxisAlignedBB((double)(-this.radius_x), (double)(-this.radius_y), (double)(-this.radius_z), (double)(1 + this.radius_x), (double)(1 + this.radius_y), (double)(1 + this.radius_z));
        this.extraShells = this.properties.get(PROP_EXTRA);
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
        this.poison_duration = this.properties.get(PROP_POISON_DURATION);
        this.poison_amplifier = this.properties.get(PROP_POISON_AMPLIFIER);
        this.levitate_duration = this.properties.get(PROP_LEVITATE_DURATION);
        this.weakness_duration = this.properties.get(PROP_WEAKNESS_DURATION);
        this.slow_duration = this.properties.get(PROP_SLOW_DURATION);
        this.slow_amplifier = this.properties.get(PROP_SLOW_AMPLIFIER);
        this.bleed_duration = this.properties.get(PROP_BLEED_DURATION);
        this.bleed_amplifier = this.properties.get(PROP_BLEED_AMPLIFIER);
        this.fire_damage = this.properties.get(PROP_FIRE_DAMAGE).floatValue();
        this.dagger_damage = this.properties.get(PROP_DAGGER_DAMAGE).floatValue();
        this.radiant_damage = this.properties.get(PROP_RADIANT_DAMAGE).floatValue();
        this.weakness_amplifier = this.properties.get(PROP_WEAKNESS_AMPLIFIER);
    }

    static {
        RADIANT.addConflicts(SLASHING, POISON, LEVITATE, WEAKNESS, SLOW);
        SLASHING.addConflicts(POISON, LEVITATE, WEAKNESS, SLOW);
        POISON.addConflicts(LEVITATE, WEAKNESS, SLOW);
        LEVITATE.addConflicts(WEAKNESS, SLOW);
        WEAKNESS.addConflict(SLOW);
        spellName = new ResourceLocation("roots", "spell_petal_shell");
        instance = new SpellPetalShell(spellName);
    }
}

