/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell.info;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.spell.FakeSpell;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.spell.info.AbstractSpellModifiers;
import epicsquid.roots.spell.info.LibrarySpellInfo;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class StaffSpellInfo
extends AbstractSpellModifiers<StaffModifierInstanceList> {
    public static StaffSpellInfo EMPTY = new StaffSpellInfo(FakeSpell.INSTANCE);
    private int cooldown = -1;
    private long cooldownStop = -1L;

    public StaffSpellInfo(SpellBase spell) {
        super(spell);
        this.modifiers = new StaffModifierInstanceList(spell);
    }

    @Override
    public StaffModifierInstanceList getModifiers() {
        return (StaffModifierInstanceList)this.modifiers;
    }

    @Override
    public void setModifiers(StaffModifierInstanceList modifiers) {
        this.modifiers = modifiers;
    }

    public boolean tick() {
        if (this.cooldown == -1) {
            return false;
        }
        --this.cooldown;
        if (this.cooldown <= 0) {
            this.cooldown = -1;
        }
        return true;
    }

    public boolean onCooldown() {
        return this.cooldown != -1;
    }

    public int cooldownLeft() {
        return this.cooldown;
    }

    public int cooldownTotal() {
        SpellBase spell = this.getSpell();
        if (spell != null) {
            return spell.getCooldown();
        }
        return 0;
    }

    public void use(long cd) {
        this.cooldown = this.cooldownTotal();
        this.cooldownStop = cd + (long)this.cooldown;
    }

    public boolean validate(long cd) {
        if (this.cooldown != -1 && cd > this.cooldownStop) {
            this.cooldown = -1;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound result = super.serializeNBT();
        result.func_74782_a("m", (NBTBase)((StaffModifierInstanceList)this.modifiers).serializeNBT());
        result.func_74768_a("c", this.cooldown);
        result.func_74772_a("l", this.cooldownStop);
        return result;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.modifiers = StaffModifierInstanceList.fromNBT(nbt.func_74775_l("m"));
        this.cooldown = nbt.func_74762_e("c");
        this.cooldownStop = nbt.func_74763_f("l");
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Nullable
    public static StaffSpellInfo fromNBT(NBTTagCompound tag) {
        SpellBase spell = StaffSpellInfo.getSpellFromTag(tag);
        if (spell == null) {
            return null;
        }
        StaffSpellInfo instance = new StaffSpellInfo(spell);
        instance.deserializeNBT(tag);
        return instance;
    }

    @Nullable
    public static StaffSpellInfo fromRegistry(String name) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        SpellBase spell = SpellRegistry.getSpell(rl);
        if (spell == null) {
            return null;
        }
        return new StaffSpellInfo(spell);
    }

    public static StaffSpellInfo fromLibrary(LibrarySpellInfo incoming) {
        SpellBase spell = incoming.getSpell();
        if (spell != null) {
            StaffSpellInfo info = new StaffSpellInfo(spell);
            info.setModifiers(incoming.getModifiers().toStaff());
            return info;
        }
        return EMPTY;
    }

    public static StaffSpellInfo fromSpell(SpellBase spell, boolean modifiers) {
        StaffSpellInfo info = new StaffSpellInfo(spell);
        if (modifiers) {
            for (StaffModifierInstance modifier : info.getModifiers()) {
                modifier.setApplied();
            }
        }
        return info;
    }

    public LibrarySpellInfo toLibrary() {
        SpellBase spell = this.getSpell();
        if (spell != null) {
            LibrarySpellInfo info = new LibrarySpellInfo(spell);
            info.setObtained();
            info.setModifiers(this.getModifiers().toLibrary());
            return info;
        }
        return LibrarySpellInfo.EMPTY;
    }

    @Override
    public ItemStack asStack() {
        ItemStack stack = new ItemStack(ModItems.spell_icon);
        NBTTagCompound comp = ItemUtil.getOrCreateTag((ItemStack)stack);
        comp.func_74757_a("staff", true);
        StaffSpellStorage storage = StaffSpellStorage.fromStack(stack);
        storage.addSpell(this);
        storage.setSelectedSlot(1);
        storage.saveToStack();
        return stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaffSpellInfo that = (StaffSpellInfo)o;
        return this.cooldown == that.cooldown;
    }

    public int hashCode() {
        return Objects.hash(this.cooldown);
    }
}

