/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.network.fx.MessageImbueCompleteFX;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.FakeSpell;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.info.LibrarySpellInfo;
import epicsquid.roots.spell.info.SpellDustInfo;
import epicsquid.roots.spell.info.storage.DustSpellStorage;
import epicsquid.roots.world.data.SpellLibraryData;
import epicsquid.roots.world.data.SpellLibraryRegistry;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityImbuer
extends TileBase
implements ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TileEntityImbuer.this.func_70296_d();
            if (!((TileEntityImbuer)TileEntityImbuer.this).field_145850_b.field_72995_K) {
                TileEntityImbuer.this.updatePacketViaState();
            }
        }
    };
    private int progress = 0;
    public float angle = 0.0f;
    private UUID inserter = null;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("progress", this.progress);
        if (this.inserter != null) {
            tag.func_186854_a("inserter", this.inserter);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("handler"));
        this.progress = tag.func_74762_e("progress");
        this.inserter = tag.func_186855_b("inserter") ? tag.func_186857_a("inserter") : null;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    private boolean checkExists(int slot, ItemStack heldItem, EntityPlayer player, World world) {
        if (!world.field_72995_K) {
            FakeSpell spell;
            ItemStack inSlot = this.inventory.getStackInSlot(slot == 0 ? 1 : 0);
            if (inSlot.func_190926_b()) {
                return false;
            }
            ItemStack spellDust = ItemStack.field_190927_a;
            if (heldItem.func_77973_b() == ModItems.gramary && inSlot.func_77973_b() == ModItems.spell_dust) {
                spellDust = inSlot;
            } else if (heldItem.func_77973_b() == ModItems.spell_dust && inSlot.func_77973_b() == ModItems.gramary) {
                spellDust = heldItem;
            }
            if (spellDust.func_190926_b()) {
                player.func_146105_b(new TextComponentTranslation("roots.message.spell_invalid", new Object[0]).func_150255_a(new Style().func_150238_a(FakeSpell.INSTANCE.getTextColor()).func_150227_a(Boolean.valueOf(true))), true);
                return true;
            }
            DustSpellStorage cap = DustSpellStorage.fromStack(spellDust);
            SpellBase spellBase = spell = cap != null && cap.getSelectedInfo() != null ? ((SpellDustInfo)cap.getSelectedInfo()).getSpell() : FakeSpell.INSTANCE;
            if (spell == null) {
                spell = FakeSpell.INSTANCE;
            }
            SpellLibraryData library = SpellLibraryRegistry.getData(player);
            if (spell == FakeSpell.INSTANCE) {
                player.func_146105_b(new TextComponentTranslation("roots.message.spell_invalid", new Object[0]).func_150255_a(new Style().func_150238_a(spell.getTextColor()).func_150227_a(Boolean.valueOf(true))), true);
                return true;
            }
            LibrarySpellInfo lib = library.getData(spell);
            if (lib.isObtained()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("roots.message.spell_already", new Object[]{new TextComponentTranslation(spell.getTranslationKey() + ".name", new Object[0]).func_150255_a(new Style().func_150238_a(spell.getTextColor()).func_150227_a(Boolean.valueOf(true)))}), true);
                return true;
            }
        }
        return false;
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            ItemStack attemptedInsert;
            ItemStack toInsert;
            int slot = -1;
            if (heldItem.func_77973_b() == ModItems.spell_dust) {
                slot = 0;
            } else if (heldItem.func_77973_b() == ModItems.gramary) {
                slot = 1;
            }
            if (slot != -1) {
                if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                    if (world.field_72995_K) {
                        return true;
                    }
                    toInsert = heldItem.func_77946_l();
                    toInsert.func_190920_e(1);
                    if (this.checkExists(slot, heldItem, player, world)) {
                        return true;
                    }
                    attemptedInsert = this.inventory.insertItem(slot, toInsert, false);
                    if (attemptedInsert.func_190926_b()) {
                        this.inserter = player.func_110124_au();
                        player.func_184586_b(hand).func_190918_g(1);
                        this.func_70296_d();
                        this.updatePacketViaState();
                        world.func_184133_a(null, this.func_174877_v(), ModSounds.Events.IMBUER_ADD_ITEM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        return true;
                    }
                }
            } else if (this.inventory.getStackInSlot(0).func_190926_b() && this.inventory.getStackInSlot(1).func_190926_b()) {
                if ((heldItem.func_77951_h() || heldItem.func_77948_v() && heldItem.func_77973_b() != Items.field_151134_bR) && (attemptedInsert = this.inventory.insertItem(1, toInsert = heldItem.func_77946_l(), true)).func_190926_b()) {
                    this.inventory.insertItem(1, toInsert, false);
                    player.func_184586_b(hand).func_190918_g(1);
                    if (player.func_184586_b(hand).func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    this.func_70296_d();
                    this.updatePacketViaState();
                    world.func_184133_a(null, this.func_174877_v(), ModSounds.Events.IMBUER_ADD_ITEM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            } else {
                ItemStack toRepair = this.inventory.getStackInSlot(1);
                if (GeneralConfig.AllowImbuerRepair && !toRepair.func_190926_b() && toRepair.func_77951_h() && toRepair.func_77973_b().func_82789_a(toRepair, heldItem) && this.inventory.getStackInSlot(0).func_190926_b()) {
                    ItemStack result;
                    ItemStack repairItem = heldItem.func_77946_l();
                    repairItem.func_190920_e(1);
                    int repairAmount = Math.min(toRepair.func_77952_i(), toRepair.func_77958_k() / GeneralConfig.MaxDamageDivisor);
                    if (repairAmount > 0 && (result = this.inventory.insertItem(0, repairItem, true)).func_190926_b()) {
                        this.inventory.insertItem(0, repairItem, false);
                        player.func_184586_b(hand).func_190918_g(1);
                        if (player.func_184586_b(hand).func_190916_E() == 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                        this.func_70296_d();
                        this.updatePacketViaState();
                        world.func_184133_a(null, this.func_174877_v(), ModSounds.Events.IMBUER_ADD_ITEM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        return true;
                    }
                } else if (GeneralConfig.AllowImbuerDisenchant && !toRepair.func_190926_b() && toRepair.func_77948_v() && heldItem.func_77973_b() == ModItems.runic_dust) {
                    ItemStack runicDust = heldItem.func_77946_l();
                    runicDust.func_190920_e(1);
                    ItemStack result = this.inventory.insertItem(0, runicDust, true);
                    if (result.func_190926_b()) {
                        this.inventory.insertItem(0, runicDust, false);
                        player.func_184586_b(hand).func_190918_g(1);
                        if (player.func_184586_b(hand).func_190916_E() == 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                        this.func_70296_d();
                        this.updatePacketViaState();
                        world.func_184133_a(null, this.func_174877_v(), ModSounds.Events.IMBUER_ADD_ITEM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        return true;
                    }
                }
            }
        }
        if (heldItem.func_190926_b() && !world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                if (!this.dropItemInInventory(this.inventory, i)) continue;
                world.func_184133_a(null, this.func_174877_v(), ModSounds.Events.IMBUER_REMOVE_ITEM, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }

    public void func_73660_a() {
        this.angle += 1.0f;
        if (!this.inventory.getStackInSlot(0).func_190926_b() && !this.inventory.getStackInSlot(1).func_190926_b()) {
            SpellBase spell;
            ++this.progress;
            this.angle += 2.0f;
            ItemStack spellDust = this.inventory.getStackInSlot(0);
            DustSpellStorage capability = DustSpellStorage.fromStack(spellDust);
            if (capability != null && capability.getSelectedInfo() != null) {
                spell = ((SpellDustInfo)capability.getSelectedInfo()).getSpell();
                if (spell == null) {
                    spell = FakeSpell.INSTANCE;
                }
            } else {
                spell = FakeSpell.INSTANCE;
            }
            if (this.field_145850_b.field_72995_K) {
                BlockPos pos = this.func_174877_v();
                float x = pos.func_177958_n();
                float y = pos.func_177956_o();
                float z = pos.func_177952_p();
                if (Util.rand.nextInt(2) == 0) {
                    ParticleUtil.spawnParticleLineGlow(this.field_145850_b, x + 0.5f, y + 0.125f, z + 0.5f, x + 0.5f + 0.5f * (Util.rand.nextFloat() - 0.5f), y + 1.0f, z + 0.5f + 0.5f * (Util.rand.nextFloat() - 0.5f), spell.getFirstColours(0.25f), 4.0f, 40);
                } else {
                    ParticleUtil.spawnParticleLineGlow(this.field_145850_b, x + 0.5f, y + 0.125f, z + 0.5f, x + 0.5f + 0.5f * (Util.rand.nextFloat() - 0.5f), y + 1.0f, z + 0.5f + 0.5f * (Util.rand.nextFloat() - 0.5f), spell.getSecondColours(0.25f), 4.0f, 40);
                }
            } else if (this.progress % 20 == 0) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), ModSounds.Events.IMBUER_USE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (this.progress > 200) {
                this.progress = 0;
                if (!this.field_145850_b.field_72995_K) {
                    ItemStack inSlot = this.inventory.getStackInSlot(1);
                    if (inSlot.func_77973_b() == ModItems.gramary && spell != FakeSpell.INSTANCE) {
                        if (this.inserter == null) {
                            Util.spawnInventoryInWorld((World)this.field_145850_b, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
                        } else {
                            SpellLibraryData library = SpellLibraryRegistry.getData(this.inserter);
                            library.addSpell(spell);
                            PacketHandler.sendToAllTracking((IMessage)new MessageImbueCompleteFX(spell.getName(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5), (TileEntity)this);
                            if (this.inserter != null) {
                                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.inserter);
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("roots.message.spell_imbued", new Object[]{new TextComponentTranslation(spell.getTranslationKey() + ".name", new Object[0]).func_150255_a(new Style().func_150238_a(spell.getTextColor()).func_150227_a(Boolean.valueOf(true)))}), true);
                            }
                        }
                        this.inventory.extractItem(0, 1, false);
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), ModSounds.Events.IMBUER_FINISHED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.func_70296_d();
                        this.updatePacketViaState();
                    } else {
                        ItemStack repairItem = this.inventory.extractItem(0, 1, false);
                        ItemStack toRepair = this.inventory.extractItem(1, 1, false);
                        if (repairItem.func_77973_b() == ModItems.runic_dust) {
                            NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)toRepair);
                            if (tag.func_74764_b("ench")) {
                                int rep;
                                tag.func_82580_o("ench");
                                toRepair.func_77982_d(tag);
                                if (GeneralConfig.AllowImbuerDisenchantReduceCost && (rep = toRepair.func_82838_A()) > 0) {
                                    toRepair.func_82841_c(rep - rep / 3);
                                }
                            }
                        } else {
                            int repairAmount = Math.min(toRepair.func_77952_i(), toRepair.func_77958_k() / 4);
                            if (repairAmount > 0) {
                                toRepair.func_77964_b(toRepair.func_77952_i() - repairAmount);
                            }
                        }
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, toRepair));
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), ModSounds.Events.IMBUER_FINISHED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        this.func_70296_d();
                        this.updatePacketViaState();
                        PacketHandler.sendToAllTracking((IMessage)new MessageImbueCompleteFX("fake_spell", (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5), (TileEntity)this);
                    }
                }
            }
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.updatePacketViaState();
            }
        } else if (this.progress != 0) {
            this.progress = 0;
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                this.updatePacketViaState();
            }
        }
    }
}

