/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.world.data;

import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.item.PouchType;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.items.ItemStackHandler;

public class PouchHandlerData
extends WorldSavedData {
    private static final String identifier = "Inventory-";
    private UUID uuid;
    private MarkDirtyHandler inventoryHandler;
    private HerbHandler herbHandler;
    private PouchType type = null;
    private boolean defer = false;

    public static String name(UUID uuid) {
        return identifier + uuid.toString();
    }

    public PouchType getType() {
        return this.type;
    }

    public PouchHandlerData(String identifier) {
        super(identifier);
        this.uuid = UUID.fromString(identifier.replace(identifier, ""));
        this.defer = true;
    }

    public PouchHandlerData(UUID uuid, PouchType type) {
        super(PouchHandlerData.name(uuid));
        this.uuid = uuid;
        this.type = type;
        this.createHandler();
    }

    public void upgrade(PouchType newType) {
        if (this.type.ordinal() >= newType.ordinal()) {
            return;
        }
        this.type = newType;
        this.inventoryHandler.setSize(this.type.inventorySlots());
        this.herbHandler.setSize(this.type.herbSlots());
        this.func_76185_a();
    }

    private void createHandler() {
        if (this.type == null) {
            throw new IllegalStateException("Attempted to instantiate PouchHandlerData before type was set.");
        }
        this.inventoryHandler = new MarkDirtyHandler(this.type.inventorySlots());
        this.herbHandler = new HerbHandler(this.type.herbSlots());
    }

    public int refill(ItemStack herbStack) {
        return this.herbHandler.refill(herbStack);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public MarkDirtyHandler getInventoryHandler() {
        return this.inventoryHandler;
    }

    public HerbHandler getHerbHandler() {
        return this.herbHandler;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.type = PouchType.fromOrdinal(nbt.func_74762_e("pouch"));
        if (this.defer) {
            this.createHandler();
        }
        this.inventoryHandler.deserializeNBT(nbt.func_74775_l("inventory"));
        this.herbHandler.deserializeNBT(nbt.func_74775_l("herbs"));
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("pouch", this.type.ordinal());
        compound.func_74782_a("inventory", (NBTBase)this.inventoryHandler.serializeNBT());
        compound.func_74782_a("herbs", (NBTBase)this.herbHandler.serializeNBT());
        return compound;
    }

    public class HerbHandler
    extends MarkDirtyHandler {
        public HerbHandler(int size) {
            super(size);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return HerbRegistry.isHerb(stack.func_77973_b());
        }

        public int refill(ItemStack herbStack) {
            if (!this.containsHerb(herbStack.func_77973_b())) {
                return herbStack.func_190916_E();
            }
            Item herb = herbStack.func_77973_b();
            int count = herbStack.func_190916_E();
            for (int i = 0; i < this.stacks.size(); ++i) {
                int consumed;
                ItemStack stack = (ItemStack)this.stacks.get(i);
                if (stack.func_77973_b() == herb && stack.func_190916_E() < stack.func_77976_d() && (consumed = Math.min(count, stack.func_77976_d() - stack.func_190916_E())) > 0) {
                    stack.func_190917_f(consumed);
                    count = Math.max(0, count - consumed);
                    this.stacks.set(i, (Object)stack);
                }
                if (count != 0) continue;
                return 0;
            }
            return count;
        }

        public boolean containsHerb(Item item) {
            for (ItemStack stack : this.stacks) {
                if (stack.func_77973_b() != item) continue;
                return true;
            }
            return false;
        }
    }

    public class MarkDirtyHandler
    extends ItemStackHandler {
        public MarkDirtyHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            PouchHandlerData.this.func_76185_a();
        }

        public void setSize(int size) {
            NonNullList original = this.stacks;
            super.setSize(size);
            for (int i = 0; i < Math.min(original.size(), size); ++i) {
                this.stacks.set(i, original.get(i));
            }
        }
    }
}

