/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.world.data;

import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class UUIDRegistry<T extends WorldSavedData> {
    private Class<? extends T> clazz;
    private Function<UUID, String> nameConverter;
    private Function<UUID, T> builder;

    public UUIDRegistry(Class<? extends T> clazz, Function<UUID, String> nameConverter, Function<UUID, T> builder) {
        this.clazz = clazz;
        this.nameConverter = nameConverter;
        this.builder = builder;
    }

    public T getDataInternal(UUID id) {
        WorldServer server = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        MapStorage storage = server.func_175693_T();
        if (storage == null) {
            throw new NullPointerException("Map storage is null");
        }
        WorldSavedData data = storage.func_75742_a(this.clazz, this.nameConverter.apply(id));
        if (data == null) {
            data = (WorldSavedData)this.builder.apply(id);
            server.func_175693_T().func_75745_a(this.nameConverter.apply(id), data);
        }
        return (T)data;
    }

    public T clearDataInternal(UUID id) {
        WorldServer server = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        MapStorage storage = server.func_175693_T();
        if (storage == null) {
            throw new NullPointerException("Map storage is null");
        }
        WorldSavedData data = (WorldSavedData)this.builder.apply(id);
        server.func_175693_T().func_75745_a(this.nameConverter.apply(id), data);
        data.func_76185_a();
        server.func_175693_T().func_75744_a();
        return (T)data;
    }
}

