/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.block;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tk.zeitheron.solarflux.SolarFlux;
import tk.zeitheron.solarflux.api.SolarFluxAPI;
import tk.zeitheron.solarflux.api.SolarInfo;
import tk.zeitheron.solarflux.api.SolarInstance;
import tk.zeitheron.solarflux.block.tile.TileBaseSolar;
import tk.zeitheron.solarflux.items.ItemUpgrade;
import tk.zeitheron.solarflux.utils.PositionedStateImplementation;

public class BlockBaseSolar
extends Block
implements ITileEntityProvider {
    public final SolarInfo solarInfo;
    protected AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);

    public BlockBaseSolar(SolarInfo solarInfo) {
        super(Material.field_151573_f);
        this.func_149647_a(SolarFluxAPI.tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.solarInfo = solarInfo;
        ResourceLocation r = solarInfo.getRegistryName();
        this.setRegistryName(r.func_110624_b(), (solarInfo.isCustom ? "custom_" : "") + "solar_panel_" + r.func_110623_a());
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149711_c(4.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (Math.abs((double)(this.solarInfo.getHeight() / 16.0f) - this.aabb.field_72337_e) > 1.0E-4) {
            this.aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)(this.solarInfo.getHeight() + 0.015625f), 1.0);
        }
        return this.aabb;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (this.isSideSolid(state, worldIn, pos, face)) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.solarInfo.getGeneration() <= 0L || this.solarInfo.getCapacity() <= 0L || this.solarInfo.getTransfer() <= 0L) {
            return;
        }
        super.func_149666_a(tab, items);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        SolarInstance i = new SolarInstance();
        i.delegate = this.solarInfo.getRegistryName();
        i.reset();
        return new TileBaseSolar(i);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            TileBaseSolar spt;
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileBaseSolar) {
                spt = (TileBaseSolar)tile;
            } else {
                spt = (TileBaseSolar)this.func_149915_a(worldIn, 0);
                worldIn.func_175690_a(pos, (TileEntity)spt);
            }
            spt.loadFromItem(stack);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!this.canHarvestBlock((IBlockAccess)worldIn, pos, player)) {
            super.func_176208_a(worldIn, pos, state, player);
            return;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileBaseSolar) {
            TileBaseSolar te = (TileBaseSolar)tileentity;
            if (!worldIn.field_72995_K) {
                if (!player.func_70093_af()) {
                    te.upgradeInventory.drop(worldIn, pos);
                    te.chargeInventory.drop(worldIn, pos);
                }
                EntityItem item = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)((float)pos.func_177956_o() + this.getPanelData().getHeight() / 2.0f), (double)pos.func_177952_p() + 0.5, player.func_70093_af() ? te.generateItem(Item.func_150898_a((Block)this)) : new ItemStack((Block)this));
                item.func_174869_p();
                worldIn.func_72838_d((Entity)item);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) instanceof TileBaseSolar) {
            ItemUpgrade iu;
            TileBaseSolar tbs;
            int amt;
            ItemStack held = playerIn.func_184586_b(hand);
            if (!held.func_190926_b() && held.func_77973_b() instanceof ItemUpgrade && (amt = (tbs = (TileBaseSolar)worldIn.func_175625_s(pos)).getUpgrades(held.func_77973_b())) < (iu = (ItemUpgrade)held.func_77973_b()).getMaxUpgrades() && iu.canInstall(tbs, held, tbs.upgradeInventory)) {
                boolean installed = false;
                for (int i = 0; i < tbs.upgradeInventory.func_70302_i_(); ++i) {
                    ItemStack stack = tbs.upgradeInventory.func_70301_a(i);
                    if (stack.func_77969_a(held) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)held)) {
                        int allow = Math.min(iu.getMaxUpgrades() - tbs.getUpgrades(iu), Math.min(iu.getItemStackLimit(stack) - stack.func_190916_E(), held.func_190916_E()));
                        stack.func_190917_f(allow);
                        held.func_190918_g(allow);
                        installed = true;
                        break;
                    }
                    if (!stack.func_190926_b()) continue;
                    int allow = Math.min(iu.getMaxUpgrades() - tbs.getUpgrades(iu), held.func_190916_E());
                    ItemStack copy = held.func_77946_l();
                    held.func_190918_g(allow);
                    copy.func_190920_e(allow);
                    tbs.upgradeInventory.func_70299_a(i, copy);
                    installed = true;
                    break;
                }
                if (installed) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.1f, 1.0f);
                    return true;
                }
            }
            playerIn.openGui((Object)SolarFlux.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PositionedStateImplementation.actualize(state, world, pos);
    }

    public SolarInfo getPanelData() {
        return this.solarInfo;
    }
}

