/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.block.property;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import thecodex6824.thaumicaugmentation.api.TABlocks;

public interface ITASlabType {
    public static final PropertyEnum<SlabType> SLAB_TYPE = PropertyEnum.func_177709_a((String)"ta_slab_type", SlabType.class);
    public static final PropertyBool DOUBLE = PropertyBool.func_177716_a((String)"ta_slab_double");

    public static enum SlabType implements IStringSerializable
    {
        ANCIENT_TILE(0, () -> Material.field_151576_e, () -> SoundType.field_185851_d, () -> new ItemStack(TABlocks.SLAB, 1, 0), MapColor.field_151676_q);

        private int meta;
        private Supplier<Material> mat;
        private Supplier<SoundType> sound;
        private Supplier<ItemStack> drop;
        private MapColor color;

        private SlabType(int m, Supplier<Material> mt, Supplier<SoundType> s, Supplier<ItemStack> b, MapColor c) {
            this.meta = m;
            this.mat = mt;
            this.sound = s;
            this.drop = b;
            this.color = c;
        }

        public int getMeta() {
            return this.meta;
        }

        public Material getMaterial() {
            return this.mat.get();
        }

        public SoundType getSoundType() {
            return this.sound.get();
        }

        public ItemStack getDrop() {
            return this.drop.get();
        }

        public MapColor getMapColor() {
            return this.color;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        @Nullable
        public static SlabType fromMeta(int id) {
            for (SlabType type : SlabType.values()) {
                if (type.getMeta() != id) continue;
                return type;
            }
            return null;
        }
    }
}

