/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.impetus;

import java.lang.ref.WeakReference;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;

public class WeakImpetusStorage
implements IImpetusStorage,
INBTSerializable<NBTTagCompound> {
    protected WeakReference<IImpetusStorage> wrapped;

    public WeakImpetusStorage() {
        this.wrapped = new WeakReference<Object>(null);
    }

    public WeakImpetusStorage(IImpetusStorage storage) {
        this.bind(storage);
    }

    public void bind(IImpetusStorage storage) {
        this.wrapped = new WeakReference<IImpetusStorage>(storage);
    }

    public boolean isValid() {
        return this.wrapped.get() != null;
    }

    @Override
    public boolean canExtract() {
        IImpetusStorage s = (IImpetusStorage)this.wrapped.get();
        return s != null && s.canExtract();
    }

    @Override
    public boolean canReceive() {
        IImpetusStorage s = (IImpetusStorage)this.wrapped.get();
        return s != null && s.canReceive();
    }

    @Override
    public long extractEnergy(long maxToExtract, boolean simulate) {
        IImpetusStorage s = (IImpetusStorage)this.wrapped.get();
        return s != null ? s.extractEnergy(maxToExtract, simulate) : 0L;
    }

    @Override
    public long receiveEnergy(long maxToReceive, boolean simulate) {
        IImpetusStorage s = (IImpetusStorage)this.wrapped.get();
        return s != null ? s.extractEnergy(maxToReceive, simulate) : 0L;
    }

    @Override
    public long getEnergyStored() {
        IImpetusStorage s = (IImpetusStorage)this.wrapped.get();
        return s != null ? s.getEnergyStored() : 0L;
    }

    @Override
    public long getMaxEnergyStored() {
        IImpetusStorage s = (IImpetusStorage)this.wrapped.get();
        return s != null ? s.getMaxEnergyStored() : 0L;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }
}

