/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapedArcaneRecipe;

public class ShapedArcaneCraftingRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        String research = JsonUtils.func_151200_h((JsonObject)json, (String)"research");
        int vis = JsonUtils.func_151203_m((JsonObject)json, (String)"vis");
        AspectList aspects = new AspectList();
        JsonObject aspectJson = JsonUtils.func_151218_a((JsonObject)json, (String)"aspects", (JsonObject)new JsonObject());
        for (Object entry : aspectJson.entrySet()) {
            Aspect aspect = Aspect.getAspect((String)((String)entry.getKey()));
            if (aspect == null) {
                throw new JsonSyntaxException("Invalid aspect: '" + (String)entry.getKey() + "' is not a valid aspect name");
            }
            if (((JsonElement)entry.getValue()).isJsonNull()) {
                throw new JsonSyntaxException("Missing aspect count for aspect + '" + (String)entry.getKey() + "'");
            }
            aspects.add(aspect, ((JsonElement)entry.getValue()).getAsInt());
        }
        Char2ObjectOpenHashMap ing = new Char2ObjectOpenHashMap();
        for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ing.put(((String)entry.getKey()).toCharArray()[0], (Object)CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
        }
        ing.put(' ', (Object)Ingredient.field_193370_a);
        JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        if (patternJ.size() > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (line.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            pattern[x] = line;
        }
        NonNullList input = NonNullList.func_191197_a((int)(pattern[0].length() * pattern.length), (Object)Ingredient.field_193370_a);
        HashSet keys = Sets.newHashSet((Iterable)ing.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient i = (Ingredient)ing.get(chr);
                if (i == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                input.set(x++, (Object)i);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
        ItemStack output = null;
        try {
            output = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        }
        catch (JsonParseException ex) {
            try {
                output = CraftingHelper.getIngredient((JsonElement)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context).func_193365_a()[0];
            }
            catch (JsonParseException oof) {
                throw new JsonParseException("Failed to parse recipe output as itemstack or ingredient");
            }
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.input = input;
        return new ShapedArcaneRecipe(new ResourceLocation(group), research, vis, aspects, output, primer);
    }
}

