/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;

public class ShapelessArcaneCraftingRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        String research = JsonUtils.func_151200_h((JsonObject)json, (String)"research");
        int vis = JsonUtils.func_151203_m((JsonObject)json, (String)"vis");
        AspectList aspects = new AspectList();
        JsonObject aspectJson = JsonUtils.func_151218_a((JsonObject)json, (String)"aspects", (JsonObject)new JsonObject());
        for (Object entry : aspectJson.entrySet()) {
            Aspect aspect = Aspect.getAspect((String)((String)entry.getKey()));
            if (aspect == null) {
                throw new JsonSyntaxException("Invalid aspect: '" + (String)entry.getKey() + "' is not a valid aspect name");
            }
            if (((JsonElement)entry.getValue()).isJsonNull()) {
                throw new JsonSyntaxException("Missing aspect count for aspect + '" + (String)entry.getKey() + "'");
            }
            aspects.add(aspect, ((JsonElement)entry.getValue()).getAsInt());
        }
        NonNullList ings = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ings.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
        }
        if (ings.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ings.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe");
        }
        ItemStack output = null;
        try {
            output = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        }
        catch (JsonParseException ex) {
            try {
                output = CraftingHelper.getIngredient((JsonElement)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context).func_193365_a()[0];
            }
            catch (JsonParseException oof) {
                throw new JsonParseException("Failed to parse recipe output as itemstack or ingredient");
            }
        }
        return new ShapelessArcaneRecipe(new ResourceLocation(group), research, vis, aspects, output, ings.toArray((Object[])new Ingredient[0]));
    }
}

