/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.util;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class FluxRiftReconstructor {
    protected int seed;
    protected int size;
    protected Vec3d[] points;
    protected float[] widths;
    protected AxisAlignedBB dimensions;

    protected FluxRiftReconstructor(int riftSeed, int riftSize, Vec3d[] rPoints, float[] rWidths) {
        this.seed = riftSeed;
        this.size = riftSize;
        this.points = rPoints;
        this.widths = rWidths;
        double x1 = Double.MAX_VALUE;
        double y1 = Double.MAX_VALUE;
        double z1 = Double.MAX_VALUE;
        double x2 = Double.MIN_VALUE;
        double y2 = Double.MIN_VALUE;
        double z2 = Double.MIN_VALUE;
        for (Vec3d point : this.points) {
            if (point.field_72450_a < x1) {
                x1 = point.field_72450_a;
            }
            if (point.field_72448_b < y1) {
                y1 = point.field_72448_b;
            }
            if (point.field_72449_c < z1) {
                z1 = point.field_72449_c;
            }
            if (point.field_72450_a > x2) {
                x2 = point.field_72450_a;
            }
            if (point.field_72448_b > y2) {
                y2 = point.field_72448_b;
            }
            if (!(point.field_72449_c > z2)) continue;
            z2 = point.field_72449_c;
        }
        this.dimensions = new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public FluxRiftReconstructor(int riftSeed, int riftSize) {
        int i;
        this.seed = riftSeed;
        this.size = riftSize;
        Random rand = new Random(this.seed);
        Vec3d right = new Vec3d(rand.nextGaussian(), rand.nextGaussian(), rand.nextGaussian()).func_72432_b();
        Vec3d left = right.func_186678_a(-1.0);
        Vec3d currentRight = new Vec3d(0.0, 0.0, 0.0);
        Vec3d currentLeft = new Vec3d(0.0, 0.0, 0.0);
        int steps = (int)Math.ceil((double)this.size / 3.0);
        ArrayList<Vec3d> p = new ArrayList<Vec3d>();
        ArrayList<Float> w = new ArrayList<Float>();
        float girth = (float)this.size / 300.0f;
        float girthReduction = girth / (float)steps;
        for (i = 0; i < steps; ++i) {
            girth -= girthReduction;
            right = right.func_178789_a((float)(rand.nextGaussian() * 0.33));
            right = right.func_178785_b((float)(rand.nextGaussian() * 0.33));
            currentRight = currentRight.func_178787_e(right.func_186678_a(0.2));
            p.add(currentRight);
            w.add(Float.valueOf(girth));
            left = left.func_178789_a((float)(rand.nextGaussian() * 0.33));
            left = left.func_178785_b((float)(rand.nextGaussian() * 0.33));
            currentLeft = currentLeft.func_178787_e(left.func_186678_a(0.2));
            p.add(0, currentLeft);
            w.add(0, Float.valueOf(girth));
        }
        currentRight = currentRight.func_178787_e(right.func_186678_a(0.1));
        p.add(currentRight);
        w.add(Float.valueOf(0.0f));
        currentLeft = currentLeft.func_178787_e(left.func_186678_a(0.1));
        p.add(0, currentLeft);
        w.add(0, Float.valueOf(girth));
        this.points = p.toArray(new Vec3d[p.size()]);
        this.widths = new float[w.size()];
        for (i = 0; i < this.widths.length; ++i) {
            this.widths[i] = ((Float)w.get(i)).floatValue();
        }
        double x1 = Double.MAX_VALUE;
        double y1 = Double.MAX_VALUE;
        double z1 = Double.MAX_VALUE;
        double x2 = Double.MIN_VALUE;
        double y2 = Double.MIN_VALUE;
        double z2 = Double.MIN_VALUE;
        for (Vec3d point : this.points) {
            if (point.field_72450_a < x1) {
                x1 = point.field_72450_a;
            }
            if (point.field_72448_b < y1) {
                y1 = point.field_72448_b;
            }
            if (point.field_72449_c < z1) {
                z1 = point.field_72449_c;
            }
            if (point.field_72450_a > x2) {
                x2 = point.field_72450_a;
            }
            if (point.field_72448_b > y2) {
                y2 = point.field_72448_b;
            }
            if (!(point.field_72449_c > z2)) continue;
            z2 = point.field_72449_c;
        }
        this.dimensions = new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public int getRiftSeed() {
        return this.seed;
    }

    public int getRiftSize() {
        return this.size;
    }

    public Vec3d[] getPoints() {
        return this.points;
    }

    public float[] getWidths() {
        return this.widths;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.dimensions;
    }

    public FluxRiftReconstructor onlyCenterPoints(int num) {
        if (num < 0 || num > this.points.length) {
            throw new IndexOutOfBoundsException("Requested " + num + " rift points when max is " + this.points.length);
        }
        if (num % 2 != 0) {
            throw new IllegalArgumentException("Point number must be multiple of 2");
        }
        Vec3d[] newPoints = new Vec3d[num];
        float[] newWidths = new float[num];
        for (int i = 0; i < num; ++i) {
            newPoints[i] = this.points[i + (this.points.length / 2 - num / 2)];
            newWidths[i] = this.widths[i + (this.points.length / 2 - num / 2)];
        }
        return new FluxRiftReconstructor(this.seed, this.size, newPoints, newWidths);
    }
}

