/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.ItemsTC;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.tile.TileCrabVent;

public class BlockCrabVent
extends BlockTABase
implements IDirectionalBlock,
IItemBlockProvider {
    protected static final AxisAlignedBB DOWN_BOX = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_BOX = new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB SOUTH_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
    protected static final AxisAlignedBB UP_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    protected static final AxisAlignedBB WEST_BOX = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockCrabVent() {
        super(Material.field_151576_e);
        this.func_149711_c(7.0f);
        this.func_149752_b(20.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.UP));
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlock(this){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                if (!TAConfig.disableCreativeOnlyText.getValue().booleanValue()) {
                    tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.creative_only", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)).func_150254_d());
                }
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IDirectionalBlock.DIRECTION});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)facing);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos test = pos.func_177972_a(side.func_176734_d());
        return world.func_180495_p(test).isSideSolid((IBlockAccess)world, test, side);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
            case DOWN: {
                return DOWN_BOX;
            }
            case EAST: {
                return EAST_BOX;
            }
            case NORTH: {
                return NORTH_BOX;
            }
            case SOUTH: {
                return SOUTH_BOX;
            }
            case WEST: {
                return WEST_BOX;
            }
        }
        return UP_BOX;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCrabVent();
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        if (!world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            return tile.func_145842_c(id, param);
        }
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int chance = 100;
        if (fortune > 0) {
            chance /= fortune;
        }
        if (rand.nextInt(Math.max(chance, 1)) == 0) {
            drops.add((Object)new ItemStack(ItemsTC.curio, 1, 1));
        }
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        return 15 + rand.nextInt(15) + rand.nextInt(15) + (fortune > 0 ? rand.nextInt(fortune * 3) : 0);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing dir = ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176734_d();
        if (!world.func_180495_p(pos.func_177972_a(dir)).isSideSolid((IBlockAccess)world, pos.func_177972_a(dir), dir.func_176734_d())) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }
}

