/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tips;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.darkhax.tips.TipsMod;
import net.darkhax.tips.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class TipsAPI {
    private static final List<Consumer<List<String>>> tipAdders = new ArrayList<Consumer<List<String>>>();
    private static final List<Consumer<List<String>>> tipRemovers = new ArrayList<Consumer<List<String>>>();
    private static final Random RANDOM = new Random();
    private static List<String> loadedtips = new ArrayList<String>();
    private static String currentTip;

    public static boolean addTips(Consumer<List<String>> adder) {
        return tipAdders.add(adder);
    }

    public static boolean removetips(Consumer<List<String>> remover) {
        return tipRemovers.add(remover);
    }

    public static String getRandomTip() {
        currentTip = loadedtips.isEmpty() ? TextFormatting.RED + I18n.func_135052_a((String)"tips.gui.error", (Object[])new Object[0]) : loadedtips.get(RANDOM.nextInt(loadedtips.size()));
        return currentTip;
    }

    public static void reloadTips() {
        long startTime = System.currentTimeMillis();
        loadedtips.clear();
        for (Consumer<List<String>> adder : tipAdders) {
            adder.accept(loadedtips);
        }
        for (Consumer<List<String>> remover : tipRemovers) {
            remover.accept(loadedtips);
        }
        TipsMod.LOG.info("Tips have been reloaded. Loaded {} tips. Took {}ms.", (Object)loadedtips.size(), (Object)(System.currentTimeMillis() - startTime));
    }

    public static void renderTip() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        int x = Config.xOffset * resolution.func_78325_e();
        String[] tip = currentTip.split("#SPLIT#");
        fontRenderer.func_78276_b(TextFormatting.BOLD.toString() + (tip.length == 2 ? tip[1] : I18n.func_135052_a((String)"tips.gui.title", (Object[])new Object[0])), x, resolution.func_78328_b() - Config.yOffset, Config.titleColor);
        fontRenderer.func_78279_b(tip[0], x, resolution.func_78328_b() - Config.yOffset + fontRenderer.field_78288_b, resolution.func_78326_a() / 2, Config.textColor);
    }
}

