/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.bugfixes.mixin;

import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfig;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class UTEntityAABBMixin {
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public double field_70161_v;

    @Shadow
    public abstract AxisAlignedBB func_174813_aQ();

    @Shadow
    public abstract void func_174826_a(AxisAlignedBB var1);

    @Shadow
    public abstract void func_70107_b(double var1, double var3, double var5);

    @Inject(method={"writeToNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;setUniqueId(Ljava/lang/String;Ljava/util/UUID;)V", shift=At.Shift.AFTER, ordinal=0)})
    public void utSaveAABBToNBT(NBTTagCompound compound, CallbackInfoReturnable<NBTTagCompound> ci) {
        if (UTConfig.bugfixes.utEntityAABBToggle) {
            if (UTConfig.debug.utDebugToggle) {
                UniversalTweaks.LOGGER.debug("UTEntityAABB ::: Write AABB to NBT");
            }
            AxisAlignedBB aabb = this.func_174813_aQ();
            compound.func_74782_a("AABB", (NBTBase)this.func_70087_a(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f));
        }
    }

    @Redirect(method={"readFromNBT"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;shouldSetPosAfterLoading()Z"))
    public boolean utReadAABBFromNBT(Entity entity, NBTTagCompound compound) {
        if (this.func_142008_O()) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (UTConfig.bugfixes.utEntityAABBToggle && compound.func_150297_b("AABB", 9)) {
            if (UTConfig.debug.utDebugToggle) {
                UniversalTweaks.LOGGER.debug("UTEntityAABB ::: Read AABB from NBT");
            }
            NBTTagList aabb_tag = compound.func_150295_c("AABB", 6);
            AxisAlignedBB aabb = new AxisAlignedBB(aabb_tag.func_150309_d(0), aabb_tag.func_150309_d(1), aabb_tag.func_150309_d(2), aabb_tag.func_150309_d(3), aabb_tag.func_150309_d(4), aabb_tag.func_150309_d(5));
            double deltaX = (aabb.field_72340_a + aabb.field_72336_d) / 2.0 - this.field_70165_t;
            double deltaY = aabb.field_72338_b - this.field_70163_u;
            double deltaZ = (aabb.field_72339_c + aabb.field_72334_f) / 2.0 - this.field_70161_v;
            if (deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ < 0.01) {
                this.func_174826_a(aabb);
            }
        }
        return false;
    }

    @Shadow
    protected abstract NBTTagList func_70087_a(double ... var1);

    @Shadow
    protected abstract boolean func_142008_O();
}

