/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.vanillafix.textures.mixins.client;

import java.util.List;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import org.dimdev.vanillafix.textures.IPatchedCompiledChunk;
import org.dimdev.vanillafix.textures.IPatchedTextureAtlasSprite;
import org.dimdev.vanillafix.textures.TemporaryStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeBlockModelRenderer.class})
public class MixinForgeBlockModelRenderer {
    @Inject(method={"render"}, at={@At(value="HEAD")}, remap=false)
    private static void onRender(VertexLighterFlat lighter, IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder wr, boolean checkSides, long rand, CallbackInfoReturnable<Boolean> cir) {
        CompiledChunk compiledChunk = TemporaryStorage.currentCompiledChunk.get();
        if (compiledChunk != null) {
            Set<TextureAtlasSprite> visibleTextures = ((IPatchedCompiledChunk)compiledChunk).getVisibleTextures();
            for (BakedQuad quad : model.func_188616_a(state, null, rand)) {
                if (quad.func_187508_a() == null) continue;
                visibleTextures.add(quad.func_187508_a());
            }
            for (EnumFacing side : EnumFacing.values()) {
                List quads = model.func_188616_a(state, side, rand);
                if ((quads.isEmpty() || checkSides) && !state.func_185894_c(world, pos, side)) continue;
                for (BakedQuad quad : quads) {
                    if (quad.func_187508_a() == null) continue;
                    visibleTextures.add(quad.func_187508_a());
                }
            }
        } else {
            for (BakedQuad quad : model.func_188616_a(state, null, rand)) {
                if (quad.func_187508_a() == null) continue;
                ((IPatchedTextureAtlasSprite)quad.func_187508_a()).markNeedsAnimationUpdate();
            }
            for (EnumFacing side : EnumFacing.values()) {
                List quads = model.func_188616_a(state, side, rand);
                if ((quads.isEmpty() || checkSides) && !state.func_185894_c(world, pos, side)) continue;
                for (BakedQuad quad : quads) {
                    if (quad.func_187508_a() == null) continue;
                    ((IPatchedTextureAtlasSprite)quad.func_187508_a()).markNeedsAnimationUpdate();
                }
            }
        }
    }
}

