/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.gui;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.client.gui.WElement;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.client.gui.interaction.WInteraction;

@SideOnly(value=Side.CLIENT)
public class TextElement
extends WElement<TextElement> {
    public static final int DEFAULT_COLOR = 0x404040;
    public static final Supplier<Integer> DEFAULT_COLOR_SUPPLIER = () -> 0x404040;
    private final Supplier<String> textSupplier;
    private final FontRenderer fontRenderer;
    private final boolean drawShadow;
    private final TextAnchor textAnchor;
    private Supplier<Integer> colorSupplier;

    public TextElement(@Nonnull Supplier<String> textSupplier, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y) {
        this(textSupplier, wGuiContainer, x, y, false);
    }

    public TextElement(@Nonnull Supplier<String> textSupplier, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y, boolean drawShadow) {
        this(textSupplier, wGuiContainer, x, y, drawShadow, TextAnchor.LEFT);
    }

    public TextElement(@Nonnull Supplier<String> textSupplier, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y, boolean drawShadow, @Nonnull TextAnchor textAnchor) {
        super(wGuiContainer, x, y);
        this.textSupplier = textSupplier;
        this.fontRenderer = this.getFontRenderer();
        this.drawShadow = drawShadow;
        this.textAnchor = textAnchor;
        this.colorSupplier = DEFAULT_COLOR_SUPPLIER;
        this.setForegroundCheck(interaction -> false);
    }

    public final TextElement setColor(int color) {
        this.colorSupplier = () -> color;
        return this;
    }

    public final int getColor() {
        return this.colorSupplier.get();
    }

    @Nonnull
    public TextElement setColorSupplier(@Nonnull Supplier<Integer> colorSupplier) {
        this.colorSupplier = colorSupplier;
        return this;
    }

    @Nonnull
    public final TextElement setDefaultColorSupplier() {
        this.colorSupplier = DEFAULT_COLOR_SUPPLIER;
        return this;
    }

    @Nonnull
    public String getText() {
        return this.textSupplier.get();
    }

    @Override
    public int getX() {
        return super.getX() + this.textAnchor.getX(this, this.getText());
    }

    @Override
    public int getWidth() {
        return this.fontRenderer.func_78256_a(this.getText());
    }

    @Override
    public int getHeight() {
        return this.fontRenderer.field_78288_b;
    }

    @Override
    public void draw(@Nonnull WInteraction wInteraction) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.fontRenderer.func_175065_a(this.getText(), (float)this.getUsableX(), (float)this.getUsableY(), this.getColor(), this.drawShadow);
    }

    public static enum TextAnchor {
        LEFT,
        MIDDLE,
        RIGHT;


        public int getX(@Nonnull TextElement textElement, @Nonnull String text) {
            switch (textElement.textAnchor) {
                case MIDDLE: {
                    return -(textElement.fontRenderer.func_78256_a(text) / 2);
                }
                case RIGHT: {
                    return -textElement.fontRenderer.func_78256_a(text);
                }
            }
            return 0;
        }
    }
}

