/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching.matcher;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import wanion.lib.common.Util;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.MatcherEnum;

public final class ModMatcher
extends AbstractMatcher<ModMatcher> {
    private String modId;

    public ModMatcher(@Nonnull AbstractMatching<?> matching) {
        super(matching);
    }

    @Override
    @Nonnull
    public ModMatcher copy() {
        ModMatcher nModMatcher = new ModMatcher(this.matching);
        nModMatcher.readNBT(this.writeNBT());
        return nModMatcher;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound matchingNbt = super.writeNBT();
        if (this.modId != null) {
            matchingNbt.func_74778_a("modId", this.modId);
        }
        return matchingNbt;
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("modId")) {
            this.modId = nbtTagCompound.func_74779_i("modId");
        }
    }

    @Override
    @Nonnull
    public MatcherEnum getMatcherEnum() {
        return MatcherEnum.MOD;
    }

    @Override
    @Nonnull
    public AbstractMatcher<?> validate() {
        ItemStack stack = this.getStack();
        if (!stack.func_190926_b()) {
            this.modId = Util.getModName(stack);
        }
        return this.modId != null ? this : this.matching.getDefaultMatcher();
    }

    @Override
    public boolean matches(@Nonnull ItemStack otherItemStack) {
        ItemStack stack = this.getStack();
        return !stack.func_190926_b() && !otherItemStack.func_190926_b() && this.modId.equals(Util.getModName(otherItemStack));
    }

    @Override
    @Nonnull
    public String getDescription() {
        return super.getDescription() + " " + TextFormatting.GOLD + this.modId;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ModMatcher && this.modId != null && this.modId.equals(((ModMatcher)obj).modId);
    }
}

