/*
 * Decompiled with CFR 0.152.
 */
package portablejim.additionalresources;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import portablejim.additionalresources.Ar_Reference;
import portablejim.additionalresources.LooseFilesResourcePack;

public class Ar_ModContainer
extends DummyModContainer {
    public Ar_ModContainer() {
        super(new ModMetadata());
        ModMetadata metadata = this.getMetadata();
        metadata.modId = "additionalresources";
        metadata.name = "Additional Resources";
        metadata.version = "0.1.1";
        metadata.authorList = Arrays.asList("Portablejim");
        metadata.description = "Load loose files as additional resources";
        metadata.url = "";
        metadata.screenshots = new String[0];
        metadata.logoFile = "";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public File getSource() {
        return Ar_Reference.corePluginLocation;
    }

    public Class<?> getCustomResourcePackClass() {
        return LooseFilesResourcePack.class;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        if (event.getSide() == Side.SERVER) {
            File baseDir = new File(Ar_Reference.minecraftDirectory, "mods-resourcepacks");
            try {
                for (File modDir : baseDir.listFiles()) {
                    try {
                        File testFile = new File(modDir, "lang/en_US.lang");
                        if (!testFile.exists() || !testFile.canRead()) continue;
                        LanguageMap.inject((InputStream)new FileInputStream(testFile));
                    }
                    catch (Exception e) {
                        FMLLog.getLogger().error("AdditionalResources: Error reading lang/en_us.lang for " + modDir.getName());
                    }
                }
            }
            catch (NullPointerException e) {
                FMLLog.getLogger().error("Additional Resources: Error reading from configuration directory " + baseDir.getName());
            }
        }
    }
}

