/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.biome;

import com.gildedgames.the_aether.AetherLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeStorage {
    private static final List<WeightedBiomeEntry> spawnableBiomes = new ArrayList<WeightedBiomeEntry>();
    public static File configDirectory = new File(Loader.instance().getConfigDir() + "/aether-dimension");
    public static File biomesFile = new File(configDirectory + "/biomes.txt");

    public static List<WeightedBiomeEntry> getSpawnableBiomes() {
        return spawnableBiomes;
    }

    public static void addBiome(Biome biome, int weight) {
        spawnableBiomes.add(new WeightedBiomeEntry(biome, weight));
    }

    public static void handleBiomeConfig() {
        BiomeStorage.generateBiomeConfig();
        BiomeStorage.readBiomeConfig();
    }

    public static void generateBiomeConfig() {
        try {
            if (!configDirectory.exists()) {
                configDirectory.mkdirs();
            }
            if (!biomesFile.exists()) {
                biomesFile.createNewFile();
                FileWriter biomeWriter = new FileWriter(biomesFile);
                biomeWriter.write("#Format is modId:biomeRegistryName=biomeWeight");
                biomeWriter.write(System.lineSeparator());
                biomeWriter.write("#Example being minecraft:forest=100");
                biomeWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void readBiomeConfig() {
        try {
            Scanner biomeReader = new Scanner(biomesFile);
            while (biomeReader.hasNextLine()) {
                Object[] entryValues;
                String entry = biomeReader.nextLine();
                if (!entry.contains("=") || entry.contains("#") || (entryValues = entry.split("=")).length < 2) continue;
                try {
                    String biomeName = entryValues[0];
                    int biomeWeight = Integer.parseInt(entryValues[1]);
                    for (Map.Entry biomeEntry : ForgeRegistries.BIOMES.getEntries()) {
                        ResourceLocation biomeEntryRegistryName = (ResourceLocation)biomeEntry.getKey();
                        Biome biomeEntryClass = (Biome)biomeEntry.getValue();
                        if (!biomeEntryRegistryName.toString().equals(biomeName)) continue;
                        BiomeStorage.addBiome(biomeEntryClass, biomeWeight);
                        AetherLogger.print("Biome " + biomeName + " added to Aether dimension with weight " + biomeWeight);
                    }
                }
                catch (NullPointerException | NumberFormatException exception) {
                    AetherLogger.printError("Error with biomes.txt config found at: " + Arrays.toString(entryValues));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static class WeightedBiomeEntry
    extends WeightedRandom.Item {
        public final Biome biome;

        WeightedBiomeEntry(Biome biome, int weight) {
            super(weight);
            this.biome = biome;
        }
    }
}

