/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.tiles;

import al132.alchemistry.ConfigHandler;
import al132.alchemistry.items.ModItems;
import al132.alchemistry.recipes.CombinerRecipe;
import al132.alchemistry.tiles.TileBase;
import al132.alib.tiles.ALTileStackHandler;
import al132.alib.tiles.EnergyTileImpl;
import al132.alib.tiles.IEnergyTile;
import al132.alib.tiles.IGuiTile;
import al132.alib.tiles.IItemTile;
import al132.alib.utils.extensions.IItemHandlerKt;
import al132.alib.utils.extensions.ItemStackKt;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ITickable;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010,\u001a\u00020\u001eJ\t\u0010-\u001a\u00020$H\u0096\u0001J\u0006\u0010.\u001a\u00020\u001eJ\b\u0010/\u001a\u000200H\u0016J\u0006\u00101\u001a\u000200J\u0010\u00102\u001a\u0002002\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000200H\u0016J\u0006\u00106\u001a\u000200J\u0010\u00107\u001a\u0002042\u0006\u00103\u001a\u000204H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0012X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010 \"\u0004\b+\u0010\"\u00a8\u00068"}, d2={"Lal132/alchemistry/tiles/TileChemicalCombiner;", "Lal132/alchemistry/tiles/TileBase;", "Lal132/alib/tiles/IGuiTile;", "Lnet/minecraft/util/ITickable;", "Lal132/alib/tiles/IItemTile;", "Lal132/alib/tiles/IEnergyTile;", "()V", "clientRecipeTarget", "Lal132/alib/tiles/ALTileStackHandler;", "getClientRecipeTarget", "()Lal132/alib/tiles/ALTileStackHandler;", "currentRecipe", "Lal132/alchemistry/recipes/CombinerRecipe;", "getCurrentRecipe", "()Lal132/alchemistry/recipes/CombinerRecipe;", "setCurrentRecipe", "(Lal132/alchemistry/recipes/CombinerRecipe;)V", "energyStorage", "Lnet/minecraftforge/energy/IEnergyStorage;", "getEnergyStorage", "()Lnet/minecraftforge/energy/IEnergyStorage;", "setEnergyStorage", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "owner", "", "getOwner", "()Ljava/lang/String;", "setOwner", "(Ljava/lang/String;)V", "paused", "", "getPaused", "()Z", "setPaused", "(Z)V", "progressTicks", "", "getProgressTicks", "()I", "setProgressTicks", "(I)V", "recipeIsLocked", "getRecipeIsLocked", "setRecipeIsLocked", "canProcess", "energyCapacity", "hasCurrentRecipeStage", "initInventoryInputCapability", "", "process", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "update", "updateRecipe", "writeToNBT", "alchemistry"})
public final class TileChemicalCombiner
extends TileBase
implements IGuiTile,
ITickable,
IItemTile,
IEnergyTile {
    @Nullable
    private CombinerRecipe currentRecipe;
    private boolean recipeIsLocked;
    private int progressTicks;
    private boolean paused;
    @NotNull
    private final ALTileStackHandler clientRecipeTarget;
    @NotNull
    private String owner;
    private final /* synthetic */ EnergyTileImpl $$delegate_0;

    @Nullable
    public final CombinerRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public final void setCurrentRecipe(@Nullable CombinerRecipe combinerRecipe) {
        this.currentRecipe = combinerRecipe;
    }

    public final boolean getRecipeIsLocked() {
        return this.recipeIsLocked;
    }

    public final void setRecipeIsLocked(boolean bl) {
        this.recipeIsLocked = bl;
    }

    public final int getProgressTicks() {
        return this.progressTicks;
    }

    public final void setProgressTicks(int n) {
        this.progressTicks = n;
    }

    public final boolean getPaused() {
        return this.paused;
    }

    public final void setPaused(boolean bl) {
        this.paused = bl;
    }

    @NotNull
    public final ALTileStackHandler getClientRecipeTarget() {
        return this.clientRecipeTarget;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    public final void setOwner(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.owner = string;
    }

    public void initInventoryInputCapability() {
        this.setInput(new ALTileStackHandler(this, this.getInputSlots(), this){
            final /* synthetic */ TileChemicalCombiner this$0;

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                if (!this.this$0.getRecipeIsLocked()) {
                    ItemStack itemStack = super.insertItem(slot, stack, simulate);
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"super.insertItem(slot, stack, simulate)");
                    return itemStack;
                }
                if (this.this$0.getRecipeIsLocked()) {
                    Object object = this.this$0.getCurrentRecipe();
                    if (object != null && (object = ((CombinerRecipe)object).getInputs()) != null && (object = (ItemStack)((ArrayList)object).get(slot)) != null) {
                        if (ItemStackKt.areItemsEqual((ItemStack)object, (ItemStack)stack)) {
                            ItemStack itemStack = super.insertItem(slot, stack, simulate);
                            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"super.insertItem(slot, stack, simulate)");
                            return itemStack;
                        }
                    }
                }
                return stack;
            }

            protected void onContentsChanged(int slot) {
                if (!this.this$0.getRecipeIsLocked()) {
                    this.this$0.updateRecipe();
                }
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        });
    }

    public final void updateRecipe() {
        this.currentRecipe = CombinerRecipe.Companion.matchInputs((IItemHandler)this.getInput());
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            if (this.recipeIsLocked) {
                CombinerRecipe combinerRecipe = this.currentRecipe;
                if (combinerRecipe == null || (combinerRecipe = combinerRecipe.getOutput()) == null || (combinerRecipe = combinerRecipe.func_77946_l()) == null) {
                    combinerRecipe = ItemStack.field_190927_a;
                }
                this.clientRecipeTarget.setStackInSlot(0, (ItemStack)combinerRecipe);
            }
            if (!this.paused && this.canProcess()) {
                this.process();
            }
            this.markDirtyGUIEvery(5);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void process() {
        IEnergyStorage iEnergyStorage = this.getEnergyStorage();
        Integer n = ConfigHandler.INSTANCE.getCombinerEnergyPerTick();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        iEnergyStorage.extractEnergy(n.intValue(), false);
        Integer n2 = ConfigHandler.INSTANCE.getCombinerProcessingTicks();
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        if (this.progressTicks < n2) {
            int n3 = this.progressTicks;
            this.progressTicks = n3 + 1;
        } else {
            Object object;
            this.progressTicks = 0;
            CombinerRecipe combinerRecipe = this.currentRecipe;
            if (combinerRecipe != null) {
                CombinerRecipe combinerRecipe2;
                CombinerRecipe it = combinerRecipe2 = combinerRecipe;
                ALTileStackHandler aLTileStackHandler = this.getOutput();
                ItemStack itemStack = it.getOutput().func_77946_l();
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"it.output.copy()");
                aLTileStackHandler.setOrIncrement(0, itemStack);
            }
            if ((object = this.currentRecipe) != null && (object = ((CombinerRecipe)object).getInputs()) != null) {
                Iterable $receiver$iv = (Iterable)object;
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    void stack;
                    int n4;
                    if ((n4 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n5 = n4;
                    ItemStack itemStack = (ItemStack)item$iv;
                    int index = n5;
                    if (!stack.func_190926_b()) {
                        this.getInput().decrementSlot(index, stack.func_190916_E());
                    }
                    ItemStack itemStack2 = this.getInput().getStackInSlot(index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"input.getStackInSlot(index)");
                    if (!Intrinsics.areEqual((Object)itemStack2.func_77973_b(), (Object)((Object)ModItems.INSTANCE.getSlotFiller()))) continue;
                    this.getInput().decrementSlot(index, 1);
                }
            }
        }
    }

    public final boolean hasCurrentRecipeStage() {
        if (Loader.isModLoaded((String)"gamestages")) {
            FMLCommonHandler fMLCommonHandler = FMLCommonHandler.instance();
            Intrinsics.checkExpressionValueIsNotNull((Object)fMLCommonHandler, (String)"FMLCommonHandler.instance()");
            MinecraftServer minecraftServer = fMLCommonHandler.getMinecraftServerInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)minecraftServer, (String)"FMLCommonHandler.instanc\u2026).minecraftServerInstance");
            PlayerList playerList = minecraftServer.func_184103_al();
            EntityPlayerMP entityPlayerMP = playerList.func_152612_a(this.owner);
            if (entityPlayerMP == null) {
                return false;
            }
            EntityPlayerMP playerOwner = entityPlayerMP;
            CombinerRecipe combinerRecipe = this.currentRecipe;
            return GameStageHelper.hasStage((EntityPlayer)((EntityPlayer)playerOwner), (String)(combinerRecipe != null ? combinerRecipe.getGamestage() : null));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canProcess() {
        if (this.currentRecipe == null) return false;
        CombinerRecipe combinerRecipe = this.currentRecipe;
        if (combinerRecipe == null) {
            Intrinsics.throwNpe();
        }
        if (!Intrinsics.areEqual((Object)combinerRecipe.getGamestage(), (Object)"")) {
            if (!this.hasCurrentRecipeStage()) return false;
        }
        int n = this.getEnergyStorage().getEnergyStored();
        Integer n2 = ConfigHandler.INSTANCE.getCombinerEnergyPerTick();
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        if (n < n2) return false;
        CombinerRecipe combinerRecipe2 = this.currentRecipe;
        if (combinerRecipe2 == null) {
            Intrinsics.throwNpe();
        }
        int n3 = combinerRecipe2.getOutput().func_190916_E() + IItemHandlerKt.get((IItemHandler)((IItemHandler)this.getOutput()), (int)0).func_190916_E();
        CombinerRecipe combinerRecipe3 = this.currentRecipe;
        if (combinerRecipe3 == null) {
            Intrinsics.throwNpe();
        }
        if (n3 > combinerRecipe3.getOutput().func_77976_d()) return false;
        ItemStack itemStack = IItemHandlerKt.get((IItemHandler)((IItemHandler)this.getOutput()), (int)0);
        CombinerRecipe combinerRecipe4 = this.currentRecipe;
        if (combinerRecipe4 == null) {
            Intrinsics.throwNpe();
        }
        if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)combinerRecipe4.getOutput())) {
            if (!IItemHandlerKt.get((IItemHandler)((IItemHandler)this.getOutput()), (int)0).func_190926_b()) return false;
        }
        CombinerRecipe combinerRecipe5 = this.currentRecipe;
        if (combinerRecipe5 == null) {
            Intrinsics.throwNpe();
        }
        if (!combinerRecipe5.matchesHandlerStacks(this.getInput())) return false;
        if (!this.recipeIsLocked) return true;
        CombinerRecipe combinerRecipe6 = CombinerRecipe.Companion.matchInputs((IItemHandler)this.getInput());
        CombinerRecipe combinerRecipe7 = combinerRecipe6;
        if (combinerRecipe6 == null) return false;
        ItemStack itemStack2 = combinerRecipe7.getOutput();
        combinerRecipe7 = itemStack2;
        if (itemStack2 == null) return false;
        CombinerRecipe combinerRecipe8 = this.currentRecipe;
        if (combinerRecipe8 == null) {
            Intrinsics.throwNpe();
        }
        boolean bl = ItemStackKt.areItemStacksEqual((ItemStack)combinerRecipe7, (ItemStack)combinerRecipe8.getOutput());
        if (!bl) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.recipeIsLocked = compound.func_74767_n("RecipeIsLocked");
        this.progressTicks = compound.func_74762_e("ProgressTicks");
        this.paused = compound.func_74767_n("Paused");
        String string = compound.func_74779_i("Owner");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"compound.getString(\"Owner\")");
        this.owner = string;
        if (this.recipeIsLocked) {
            ItemStackHandler tempItemHandler = new ItemStackHandler(9);
            NBTTagList recipeInputsList = compound.func_150295_c("RecipeInputs", 10);
            int n = 0;
            int n2 = recipeInputsList.func_74745_c();
            while (n < n2) {
                void i;
                tempItemHandler.setStackInSlot((int)i, new ItemStack(recipeInputsList.func_150305_b((int)i)));
                ++i;
            }
            ItemStack recipeTarget = new ItemStack(compound.func_74775_l("RecipeTarget"));
            this.currentRecipe = CombinerRecipe.Companion.matchOutput(recipeTarget);
            CombinerRecipe combinerRecipe = this.currentRecipe;
            if ((combinerRecipe == null || (combinerRecipe = combinerRecipe.getOutput()) == null || (combinerRecipe = combinerRecipe.func_77946_l()) == null) && (combinerRecipe = ItemStack.field_190927_a) == null) {
                Intrinsics.throwNpe();
            }
            this.clientRecipeTarget.setStackInSlot(0, (ItemStack)combinerRecipe);
        } else {
            this.updateRecipe();
            this.clientRecipeTarget.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        compound.func_74757_a("RecipeIsLocked", this.recipeIsLocked);
        compound.func_74768_a("ProgressTicks", this.progressTicks);
        compound.func_74757_a("Paused", this.paused);
        compound.func_74778_a("Owner", this.owner);
        if (this.recipeIsLocked && this.currentRecipe != null) {
            NBTTagList recipeInputs = new NBTTagList();
            int n = 0;
            CombinerRecipe combinerRecipe = this.currentRecipe;
            if (combinerRecipe == null) {
                Intrinsics.throwNpe();
            }
            int n2 = ((Collection)combinerRecipe.getInputs()).size();
            while (n < n2) {
                void i;
                NBTTagCompound recipeInputEntry = new NBTTagCompound();
                CombinerRecipe combinerRecipe2 = this.currentRecipe;
                if (combinerRecipe2 == null) {
                    Intrinsics.throwNpe();
                }
                ItemStack tempStack = combinerRecipe2.getInputs().get((int)i).func_77946_l();
                tempStack.func_77955_b(recipeInputEntry);
                recipeInputs.func_74742_a((NBTBase)recipeInputEntry);
                ++i;
            }
            compound.func_74782_a("RecipeInputs", (NBTBase)recipeInputs);
        }
        compound.func_74782_a("RecipeTarget", (NBTBase)IItemHandlerKt.get((IItemHandler)((IItemHandler)this.clientRecipeTarget), (int)0).serializeNBT());
        return super.func_189515_b(compound);
    }

    public TileChemicalCombiner() {
        Integer n = ConfigHandler.INSTANCE.getCombinerEnergyCapacity();
        if (n == null) {
            Intrinsics.throwNpe();
        }
        this.$$delegate_0 = new EnergyTileImpl(n.intValue());
        this.owner = "";
        this.initInventoryCapability(9, 1);
        this.clientRecipeTarget = new ALTileStackHandler(1, this){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                return stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }
        };
    }

    public int getGuiHeight() {
        return IGuiTile.DefaultImpls.getGuiHeight((IGuiTile)this);
    }

    public int getGuiWidth() {
        return IGuiTile.DefaultImpls.getGuiWidth((IGuiTile)this);
    }

    @NotNull
    public IEnergyStorage getEnergyStorage() {
        return this.$$delegate_0.getEnergyStorage();
    }

    public void setEnergyStorage(@NotNull IEnergyStorage iEnergyStorage) {
        Intrinsics.checkParameterIsNotNull((Object)iEnergyStorage, (String)"<set-?>");
        this.$$delegate_0.setEnergyStorage(iEnergyStorage);
    }

    public int energyCapacity() {
        return this.$$delegate_0.energyCapacity();
    }
}

