/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.block.AEBaseTileBlock;
import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IBlockRendering;
import appeng.bootstrap.components.BlockColorComponent;
import appeng.bootstrap.components.StateMapperComponent;
import appeng.bootstrap.components.TesrComponent;
import appeng.client.render.model.AutoRotatingModel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

class BlockRendering
implements IBlockRendering {
    @SideOnly(value=Side.CLIENT)
    private BiFunction<ModelResourceLocation, IBakedModel, IBakedModel> modelCustomizer;
    @SideOnly(value=Side.CLIENT)
    private IBlockColor blockColor;
    @SideOnly(value=Side.CLIENT)
    private TileEntitySpecialRenderer<?> tesr;
    @SideOnly(value=Side.CLIENT)
    private IStateMapper stateMapper;
    @SideOnly(value=Side.CLIENT)
    private final Map<String, IModel> builtInModels = new HashMap<String, IModel>();

    BlockRendering() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockRendering modelCustomizer(BiFunction<ModelResourceLocation, IBakedModel, IBakedModel> customizer) {
        this.modelCustomizer = customizer;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockRendering blockColor(IBlockColor blockColor) {
        this.blockColor = blockColor;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockRendering tesr(TileEntitySpecialRenderer<?> tesr) {
        this.tesr = tesr;
        return this;
    }

    @Override
    public IBlockRendering builtInModel(String name, IModel model) {
        this.builtInModels.put(name, model);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockRendering stateMapper(IStateMapper mapper) {
        this.stateMapper = mapper;
        return this;
    }

    void apply(FeatureFactory factory, Block block, Class<?> tileEntityClass) {
        if (this.tesr != null) {
            if (tileEntityClass == null) {
                throw new IllegalStateException("Tried to register a TESR for " + block + " even though no tile entity has been specified.");
            }
            factory.addBootstrapComponent(new TesrComponent(tileEntityClass, this.tesr));
        }
        if (this.modelCustomizer != null) {
            factory.addModelOverride(block.getRegistryName().func_110623_a(), this.modelCustomizer);
        } else if (block instanceof AEBaseTileBlock) {
            factory.addModelOverride(block.getRegistryName().func_110623_a(), (l, m) -> new AutoRotatingModel((IBakedModel)m));
        }
        this.builtInModels.forEach(factory::addBuiltInModel);
        if (this.blockColor != null) {
            factory.addBootstrapComponent(new BlockColorComponent(block, this.blockColor));
        }
        if (this.stateMapper != null) {
            factory.addBootstrapComponent(new StateMapperComponent(block, this.stateMapper));
        }
    }
}

