/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.materials;

import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.features.IStackSrc;
import appeng.core.features.MaterialStackSrc;
import appeng.items.AEBaseItem;
import appeng.items.materials.MaterialType;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemMaterial
extends AEBaseItem
implements IStorageComponent,
IUpgradeModule {
    public static ItemMaterial instance;
    private static final int KILO_SCALAR = 1024;
    private final Map<Integer, MaterialType> dmgToMaterial = new HashMap<Integer, MaterialType>();

    public ItemMaterial() {
        this.func_77627_a(true);
        instance = this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        Upgrades u;
        super.addCheckedInformation(stack, world, lines, advancedTooltips);
        MaterialType mt = this.getTypeByStack(stack);
        if (mt == null) {
            return;
        }
        if (mt == MaterialType.NAME_PRESS) {
            NBTTagCompound c = Platform.openNbtData(stack);
            lines.add(c.func_74779_i("InscribeName"));
        }
        if ((u = this.getType(stack)) != null) {
            ArrayList<String> textList = new ArrayList<String>();
            for (Map.Entry<ItemStack, Integer> j : u.getSupported().entrySet()) {
                IItemGroup ig;
                String str;
                String name = null;
                int limit = j.getValue();
                if (j.getKey().func_77973_b() instanceof IItemGroup && (str = (ig = (IItemGroup)j.getKey().func_77973_b()).getUnlocalizedGroupName(u.getSupported().keySet(), j.getKey())) != null) {
                    name = Platform.gui_localize(str) + (limit > 1 ? " (" + limit + ')' : "");
                }
                if (name == null) {
                    name = j.getKey().func_82833_r() + (limit > 1 ? " (" + limit + ')' : "");
                }
                if (textList.contains(name)) continue;
                textList.add(name);
            }
            Pattern p = Pattern.compile("(\\d+)[^\\d]");
            SlightlyBetterSort s = new SlightlyBetterSort(p);
            Collections.sort(textList, s);
            lines.addAll(textList);
        }
    }

    public MaterialType getTypeByStack(ItemStack is) {
        MaterialType type = this.dmgToMaterial.get(is.func_77952_i());
        return type != null ? type : MaterialType.INVALID_TYPE;
    }

    @Override
    public Upgrades getType(ItemStack itemstack) {
        switch (this.getTypeByStack(itemstack)) {
            case CARD_CAPACITY: {
                return Upgrades.CAPACITY;
            }
            case CARD_FUZZY: {
                return Upgrades.FUZZY;
            }
            case CARD_REDSTONE: {
                return Upgrades.REDSTONE;
            }
            case CARD_SPEED: {
                return Upgrades.SPEED;
            }
            case CARD_INVERTER: {
                return Upgrades.INVERTER;
            }
            case CARD_CRAFTING: {
                return Upgrades.CRAFTING;
            }
            case CARD_PATTERN_EXPANSION: {
                return Upgrades.PATTERN_EXPANSION;
            }
        }
        return null;
    }

    public IStackSrc createMaterial(MaterialType mat) {
        Preconditions.checkState((!mat.isRegistered() ? 1 : 0) != 0, (Object)"Cannot create the same material twice.");
        boolean enabled = true;
        for (AEFeature f : mat.getFeature()) {
            enabled = enabled && AEConfig.instance().isFeatureEnabled(f);
        }
        mat.setStackSrc(new MaterialStackSrc(mat, enabled));
        if (enabled) {
            mat.setItemInstance(this);
            mat.markReady();
            int newMaterialNum = mat.getDamageValue();
            if (this.dmgToMaterial.get(newMaterialNum) == null) {
                this.dmgToMaterial.put(newMaterialNum, mat);
            } else {
                throw new IllegalStateException("Meta Overlap detected.");
            }
        }
        return mat.getStackSrc();
    }

    public void registerOredicts() {
        for (MaterialType mt : ImmutableSet.copyOf(this.dmgToMaterial.values())) {
            String[] names;
            if (mt.getOreName() == null) continue;
            for (String name : names = mt.getOreName().split(",")) {
                OreDictionary.registerOre((String)name, (ItemStack)mt.stack(1));
            }
        }
    }

    public String func_77667_c(ItemStack is) {
        return "item.appliedenergistics2.material." + this.nameOf(is).toLowerCase();
    }

    @Override
    protected void getCheckedSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> itemStacks) {
        List<MaterialType> types = Arrays.asList(MaterialType.values());
        Collections.sort(types, (o1, o2) -> o1.name().compareTo(o2.name()));
        for (MaterialType mat : types) {
            if (mat.getDamageValue() < 0 || !mat.isRegistered() || mat.getItemInstance() != this) continue;
            itemStacks.add((Object)new ItemStack((Item)this, 1, mat.getDamageValue()));
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player.func_70093_af()) {
            IUpgradeModule um;
            Upgrades u;
            TileEntity te = world.func_175625_s(pos);
            IItemHandler upgrades = null;
            if (te instanceof IPartHost) {
                SelectedPart sp = ((IPartHost)te).selectPart(new Vec3d((double)hitX, (double)hitY, (double)hitZ));
                if (sp.part instanceof IUpgradeableHost) {
                    upgrades = ((ISegmentedInventory)((Object)sp.part)).getInventoryByName("upgrades");
                }
            } else if (te instanceof IUpgradeableHost) {
                upgrades = ((ISegmentedInventory)te).getInventoryByName("upgrades");
            }
            if (upgrades != null && !player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof IUpgradeModule && (u = (um = (IUpgradeModule)player.func_184586_b(hand).func_77973_b()).getType(player.func_184586_b(hand))) != null) {
                if (player.field_70170_p.field_72995_K) {
                    return EnumActionResult.PASS;
                }
                AdaptorItemHandler ad = new AdaptorItemHandler(upgrades);
                player.func_184611_a(hand, ((InventoryAdaptor)ad).addItems(player.func_184586_b(hand)));
                return EnumActionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public boolean hasCustomEntity(ItemStack is) {
        return this.getTypeByStack(is).hasCustomEntity();
    }

    public Entity createEntity(World w, Entity location, ItemStack itemstack) {
        Entity eqi;
        Class<? extends Entity> droppedEntity = this.getTypeByStack(itemstack).getCustomEntityClass();
        try {
            eqi = droppedEntity.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, ItemStack.class).newInstance(w, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
        eqi.field_70159_w = location.field_70159_w;
        eqi.field_70181_x = location.field_70181_x;
        eqi.field_70179_y = location.field_70179_y;
        if (location instanceof EntityItem && eqi instanceof EntityItem) {
            ((EntityItem)eqi).func_174869_p();
        }
        return eqi;
    }

    private String nameOf(ItemStack is) {
        if (is.func_190926_b()) {
            return "null";
        }
        MaterialType mt = this.getTypeByStack(is);
        if (mt == null) {
            return "null";
        }
        return mt.name();
    }

    @Override
    public int getBytes(ItemStack is) {
        switch (this.getTypeByStack(is)) {
            case CELL1K_PART: {
                return 1024;
            }
            case CELL4K_PART: {
                return 4096;
            }
            case CELL16K_PART: {
                return 16384;
            }
            case CELL64K_PART: {
                return 65536;
            }
        }
        return 0;
    }

    @Override
    public boolean isStorageComponent(ItemStack is) {
        switch (this.getTypeByStack(is)) {
            case CELL1K_PART: 
            case CELL4K_PART: 
            case CELL16K_PART: 
            case CELL64K_PART: {
                return true;
            }
        }
        return false;
    }

    private static class SlightlyBetterSort
    implements Comparator<String> {
        private final Pattern pattern;

        public SlightlyBetterSort(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public int compare(String o1, String o2) {
            try {
                Matcher a = this.pattern.matcher(o1);
                Matcher b = this.pattern.matcher(o2);
                if (a.find() && b.find()) {
                    int ia = Integer.parseInt(a.group(1));
                    int ib = Integer.parseInt(b.group(1));
                    return Integer.compare(ia, ib);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return o1.compareTo(o2);
        }
    }
}

