/*
 * Decompiled with CFR 0.152.
 */
package mixu.astrallevelnerf;

import mixu.astrallevelnerf.repack.com.fathzer.soft.javaluator.DoubleEvaluator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="astral-level-nerf", name="Astral Level Nerf", version="1.0.1", dependencies="required-after:astralsorcery", useMetadata=true)
public class AstralLevelNerf {
    public static final String MODID = "astral-level-nerf";
    public static final String MODNAME = "Astral Level Nerf";
    public static final String VERSION = "1.0.1";
    public static Logger logger;
    private static final DoubleEvaluator evaluator;
    @Mod.Instance(value="astral-level-nerf")
    public static AstralLevelNerf INSTANCE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        logger = event.getModLog();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static long getExpRequired(int i, long prev) {
        String replacedFormula = AstralLevelNerfConfig.levelFormula.replaceAll("(\\W?)i(\\W?)", "$1" + i + "$2").replaceAll("(\\W?)prev(\\W?)", "$1" + prev + "$1");
        try {
            return ((Double)evaluator.evaluate(replacedFormula)).longValue();
        }
        catch (IllegalArgumentException e) {
            logger.error("Formula is invalid!");
            return Long.MAX_VALUE - (long)i;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return Long.MAX_VALUE - (long)i;
        }
    }

    static {
        evaluator = new DoubleEvaluator();
    }

    @Config(modid="astral-level-nerf", name="astral-level-nerf")
    public static class AstralLevelNerfConfig {
        @Config.Name(value="level_formula")
        @Config.Comment(value={"The formula to use when calculating xp required.You can use \"i\" for the current level and \"prev\" for the previous levels xp"})
        public static String levelFormula = "prev + 150 + floor(2^(i/2+3))";
    }
}

