/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity;

import com.bewitchment.common.block.tile.entity.util.ModTileEntity;
import com.bewitchment.common.item.ItemSigil;
import com.bewitchment.common.item.ItemTaglock;
import com.bewitchment.registry.ModObjects;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntityDragonsBlood
extends ModTileEntity
implements ITickable {
    public ItemSigil sigil;
    public int cooldown = 0;
    public boolean whiteList;
    public Set<String> playerUUIDSet = new HashSet<String>();

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.readUpdateTag(tag);
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.writeUpdateTag(tag);
        return super.func_189515_b(tag);
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeUpdateTag(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writeUpdateTag(tag);
        return tag;
    }

    @Override
    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.readUpdateTag(tag);
    }

    @Override
    public boolean activate(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing face) {
        TileEntityDragonsBlood te = this;
        if (world.func_180495_p(pos).func_177230_c() == ModObjects.dragons_blood_door.door) {
            TileEntityDragonsBlood tileEntityDragonsBlood = te = world.func_175625_s(pos.func_177977_b()) instanceof TileEntityDragonsBlood ? (TileEntityDragonsBlood)world.func_175625_s(pos.func_177977_b()) : this;
        }
        if (te.sigil == null) {
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemSigil) {
                te.sigil = (ItemSigil)player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1).func_77973_b();
                te.whiteList = te.sigil.positive;
                te.playerUUIDSet.add(player.func_110124_au().toString());
                this.func_70296_d();
                return true;
            }
        } else {
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemTaglock && player.func_184586_b(hand).func_77942_o()) {
                this.modifyList(te, player.func_184586_b(hand).func_77978_p().func_74779_i("boundId"));
                this.func_70296_d();
                return true;
            }
            if (te.cooldown <= 0 && this.isPlayerOnList(te, player) == te.whiteList) {
                te.sigil.applyEffects((EntityLivingBase)player);
                te.cooldown = te.sigil.cooldown;
                this.func_70296_d();
                return true;
            }
        }
        return super.activate(world, pos, player, hand, face);
    }

    private void writeUpdateTag(NBTTagCompound tag) {
        tag.func_74778_a("sigil", this.sigil == null ? "" : this.sigil.getRegistryName().toString());
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74757_a("whitelist", this.whiteList);
        NBTTagList playerList = new NBTTagList();
        for (String s : this.playerUUIDSet) {
            playerList.func_74742_a((NBTBase)new NBTTagString(s));
        }
        tag.func_74782_a("playerList", (NBTBase)playerList);
    }

    private void readUpdateTag(NBTTagCompound tag) {
        this.sigil = tag.func_74779_i("sigil").isEmpty() ? null : (ItemSigil)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("sigil")));
        this.cooldown = tag.func_74762_e("cooldown");
        this.whiteList = tag.func_74767_n("whitelist");
        NBTTagList playerList = tag.func_150295_c("playerList", 8);
        for (int i = 0; i < playerList.func_74745_c(); ++i) {
            this.playerUUIDSet.add(playerList.func_150307_f(i));
        }
    }

    private boolean isPlayerOnList(TileEntityDragonsBlood te, EntityPlayer player) {
        return te.playerUUIDSet.contains(player.func_110124_au().toString());
    }

    private void modifyList(TileEntityDragonsBlood te, String uuid) {
        if (te.playerUUIDSet.contains(uuid)) {
            te.playerUUIDSet.remove(uuid);
        } else {
            te.playerUUIDSet.add(uuid);
        }
    }

    public void func_73660_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }
}

