/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.entity.living;

import com.bewitchment.Util;
import com.bewitchment.common.entity.living.EntityLizard;
import com.bewitchment.common.entity.spirit.demon.EntityFeuerwurm;
import com.bewitchment.common.entity.util.ModEntityTameable;
import com.bewitchment.registry.ModObjects;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntitySnake
extends ModEntityTameable {
    protected static final DataParameter<Integer> HISS_TIME = EntityDataManager.func_187226_a(EntitySnake.class, (DataSerializer)DataSerializers.field_187192_b);
    private int milkTimer = 0;

    public EntitySnake(World world) {
        super(world, new ResourceLocation("bewitchment", "entities/snake"), Items.field_151076_bf, Items.field_179558_bo, Items.field_151110_aK, Items.field_179556_br, ModObjects.lizard_leg);
        this.func_70105_a(1.0f, 0.3f);
        this.setHissTime(this.getNewHiss());
        this.field_70728_aV = 5;
    }

    public int func_70641_bl() {
        return 6;
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_179558_bo;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        if (!this.field_70170_p.field_72995_K && (this.func_70638_az() == null || this.func_70638_az().field_70128_L || this.func_70643_av() == null || this.func_70643_av().field_70128_L) && (stack = player.func_184586_b(hand)).func_77973_b() == Items.field_151069_bo) {
            if (this.milkTimer == 0 && this.func_70681_au().nextBoolean()) {
                if (this.func_70874_b() >= 0) {
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    Util.replaceAndConsumeItem(player, hand, new ItemStack(ModObjects.snake_venom));
                    this.milkTimer = 3600;
                    return true;
                }
            } else {
                this.func_70624_b((EntityLivingBase)player);
                this.func_70604_c((EntityLivingBase)player);
            }
        }
        return super.func_184645_a(player, hand);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 5.0f, 1.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e(), 10.0f, 2.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityPlayer.class, false, p -> p.func_70068_e((Entity)this) < 1.0));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityLivingBase.class, false, e -> e instanceof EntityChicken || e instanceof EntityLizard || e instanceof EntityRabbit || e instanceof EntityParrot || e.getClass().getName().endsWith("Rat")));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HISS_TIME, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("milkTimer", this.milkTimer);
        super.func_70014_b(tag);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        this.milkTimer = tag.func_74762_e("milkTimer");
        super.func_70037_a(tag);
    }

    @Override
    protected int getSkinTypes() {
        return 6;
    }

    private int getNewHiss() {
        return this.field_70146_Z.nextInt(600) + 30;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_188419_a() != MobEffects.field_76436_u && super.func_70687_e(effect);
    }

    public boolean func_70652_k(Entity entity) {
        if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e())) {
            this.func_174815_a((EntityLivingBase)this, entity);
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 0, false, false));
            }
        }
        return super.func_70652_k(entity);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 200 <= 5) {
            this.func_70691_i(2.0f);
        }
        if (this.milkTimer > 0) {
            --this.milkTimer;
        }
        if (!this.field_70122_E && this.field_70181_x <= 0.0) {
            this.field_70181_x *= 0.6;
        }
        if ((!this.field_70122_E || this.func_70605_aq().func_75640_a()) && this.getHissTime() <= 61) {
            this.setHissTime(80);
        }
        if (!this.field_70170_p.field_72995_K && this.setHissTime(this.getHissTime() - 1) <= 0) {
            this.setHissTime(this.getNewHiss());
        }
    }

    public int getHissTime() {
        return (Integer)this.field_70180_af.func_187225_a(HISS_TIME);
    }

    public int setHissTime(int time) {
        this.field_70180_af.func_187227_b(HISS_TIME, (Object)time);
        return time;
    }

    public void func_70077_a(EntityLightningBolt bolt) {
        Util.convertEntity((EntityLiving)this, (EntityLiving)new EntityFeuerwurm(this.field_70170_p));
    }
}

