/*
 * Decompiled with CFR 0.152.
 */
package org.btpos.dj2addons.crafttweaker.extrautils;

import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenDoc;
import crafttweaker.annotations.ZenRegister;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import java.util.ArrayList;
import java.util.Map;
import org.btpos.dj2addons.impl.api.extrautilities.VExtraUtilities;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ModOnly(value="extrautils2")
@ZenClass(value="dj2addons.extrautils2.Mills")
@ZenDocClass(value="dj2addons.extrautils2.Mills", description={"Handles Grid Power (GP) generator (mill) tweaks.", "Must be run with the preinit loader, specified with `#loader preinit` at the top of the file."})
@ZenDocAppend(value={"docs/include/extrautils.example.md"})
public class CTMills {
    @ZenMethod
    @ZenDocMethod(description={"Sets mill power scaling.", "Use `/dj2addons extrautils2` in-game to print all mill names."}, args={@ZenDocArg(arg="millName", info="The name of the mill to change."), @ZenDocArg(arg="values", info="An associative array of [Grid Power threshold : production percentage].")})
    @ZenDoc(value="Sets mill power scaling. See docs on GitHub.")
    public static void setScaling(String millName, Map<Float, Float> values) {
        float[] arr = new float[values.size() * 2];
        int i = 0;
        for (Map.Entry<Float, Float> entry : new ArrayList<Map.Entry<Float, Float>>(values.entrySet())) {
            arr[i] = entry.getKey().floatValue();
            arr[i + 1] = entry.getValue().floatValue();
            i += 2;
        }
        VExtraUtilities.setScaling(millName.toUpperCase().replace(" ", "_").trim(), arr);
    }
}

