/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.item;

import fi.dy.masa.enderutilities.client.renderer.item.BuildersWandRenderer;
import fi.dy.masa.enderutilities.event.RenderEventHandler;
import fi.dy.masa.enderutilities.item.ItemRuler;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;

public class RulerRenderer {
    public static final int[] COLORS = new int[]{0x70FFFF, 0xFF70FF, 0xFFFF70, 10748365, 0x3C3CC9, 14255372, 1287228, 15540789};
    protected final Minecraft mc = Minecraft.func_71410_x();
    protected final Map<Integer, List<BlockPosEU>> positions = new HashMap<Integer, List<BlockPosEU>>();
    public float partialTicksLast;

    public void renderHud() {
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.RULER);
        if (stack.func_190926_b() && ((stack = InventoryUtils.getFirstItemOfType((EntityPlayer)player, EnderUtilitiesItems.RULER)).func_190926_b() || !((ItemRuler)stack.func_77973_b()).getRenderWhenUnselected(stack))) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        this.getText(lines, stack, (EntityPlayer)player);
        RenderEventHandler.renderText(lines, 4, 0, RenderEventHandler.HudAlignment.BOTTOM_LEFT, true, true, this.mc);
    }

    private void getText(List<String> lines, ItemStack stack, EntityPlayer player) {
        String modeStr;
        ItemRuler item = (ItemRuler)stack.func_77973_b();
        int selected = item.getLocationSelection(stack);
        BlockPosEU posStart = item.getPosition(stack, selected, true);
        BlockPosEU posEnd = item.getPosition(stack, selected, false);
        if (posStart == null && posEnd == null) {
            return;
        }
        if (posStart == null) {
            posStart = posEnd;
            posEnd = new BlockPosEU((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player.field_71093_bK, EnumFacing.UP);
        } else if (posEnd == null) {
            posEnd = new BlockPosEU((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player.field_71093_bK, EnumFacing.UP);
        }
        if (posStart.getDimension() != player.field_71093_bK || posEnd.getDimension() != player.field_71093_bK) {
            return;
        }
        int lenX = Math.abs(posStart.getX() - posEnd.getX());
        int lenY = Math.abs(posStart.getY() - posEnd.getY());
        int lenZ = Math.abs(posStart.getZ() - posEnd.getZ());
        String preGreen = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        if (!item.getDistanceMode(stack)) {
            ++lenX;
            ++lenY;
            ++lenZ;
            modeStr = I18n.func_135052_a((String)"enderutilities.tooltip.item.ruler.dimensions", (Object[])new Object[0]);
        } else {
            modeStr = I18n.func_135052_a((String)"enderutilities.tooltip.item.ruler.difference", (Object[])new Object[0]);
        }
        lines.add(String.format("%s: %s%s%s - X: %s%d%s, Y: %s%d%s, Z: %s%d%s", I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]), preGreen, modeStr, rst, preGreen, lenX, rst, preGreen, lenY, rst, preGreen, lenZ, rst));
        String strStart = I18n.func_135052_a((String)"enderutilities.tooltip.item.start", (Object[])new Object[0]);
        lines.add(String.format("%s: x: %s%d%s, y: %s%d%s, z: %s%d%s", strStart, preGreen, posStart.getX(), rst, preGreen, posStart.getY(), rst, preGreen, posStart.getZ(), rst));
        String strEnd = I18n.func_135052_a((String)"enderutilities.tooltip.item.end", (Object[])new Object[0]);
        lines.add(String.format("%s: x: %s%d%s, y: %s%d%s, z: %s%d%s", strEnd, preGreen, posEnd.getX(), rst, preGreen, posEnd.getY(), rst, preGreen, posEnd.getZ(), rst));
    }

    public void renderAllPositionPairs(EntityPlayer usingPlayer, EntityPlayer clientPlayer, float partialTicks) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)usingPlayer, EnderUtilitiesItems.RULER);
        if (stack.func_190926_b() && ((stack = InventoryUtils.getFirstItemOfType(usingPlayer, EnderUtilitiesItems.RULER)).func_190926_b() || !((ItemRuler)stack.func_77973_b()).getRenderWhenUnselected(stack))) {
            return;
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        ItemRuler item = (ItemRuler)stack.func_77973_b();
        int selected = item.getLocationSelection(stack);
        if (item.getRenderAllLocations(stack)) {
            int count = item.getLocationCount(stack);
            for (int i = 0; i < count; ++i) {
                int color;
                int n = color = i < COLORS.length ? COLORS[i] : 0x70FFFF;
                if (i == selected || !item.getAlwaysRenderLocation(stack, i)) continue;
                BlockPosEU posStart = item.getPosition(stack, i, true);
                BlockPosEU posEnd = item.getPosition(stack, i, false);
                this.renderPointPair(usingPlayer, posStart, posEnd, color, clientPlayer, partialTicks);
            }
        }
        BlockPosEU posStart = item.getPosition(stack, selected, true);
        BlockPosEU posEnd = item.getPosition(stack, selected, false);
        this.renderPointPair(usingPlayer, posStart, posEnd, 0xFFFFFF, clientPlayer, partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
        this.partialTicksLast = partialTicks;
    }

    private void renderPointPair(EntityPlayer usingPlayer, BlockPosEU posStart, BlockPosEU posEnd, int color, EntityPlayer clientPlayer, float partialTicks) {
        if (posStart != null && posStart.getDimension() != usingPlayer.field_71093_bK || posEnd != null && posEnd.getDimension() != usingPlayer.field_71093_bK) {
            return;
        }
        this.updatePositions(usingPlayer, posStart, posEnd);
        this.renderPositions(clientPlayer, posStart, posEnd, color, partialTicks);
        this.renderStartAndEndPositions(clientPlayer, posStart, posEnd, partialTicks);
    }

    private void renderPositions(EntityPlayer clientPlayer, BlockPosEU posStart, BlockPosEU posEnd, int color, float partialTicks) {
        GlStateManager.func_187441_d((float)2.0f);
        for (int a = 0; a < 3; ++a) {
            List<BlockPosEU> column = this.positions.get(a);
            if (column == null) continue;
            int size = column.size();
            for (int i = 0; i < size; ++i) {
                BlockPosEU pos = column.get(i);
                AxisAlignedBB aabb = BuildersWandRenderer.createAABB(pos.getX(), pos.getY(), pos.getZ(), 0.0, partialTicks, clientPlayer);
                RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)((float)(color >>> 16 & 0xFF) / 255.0f), (float)((float)(color >>> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
            }
        }
    }

    private void renderStartAndEndPositions(EntityPlayer clientPlayer, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        AxisAlignedBB aabb;
        if (posStart != null) {
            GlStateManager.func_187441_d((float)3.0f);
            aabb = BuildersWandRenderer.createAABB(posStart.getX(), posStart.getY(), posStart.getZ(), 0.0, partialTicks, clientPlayer);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)1.0f, (float)0.06666667f, (float)0.06666667f, (float)1.0f);
        }
        if (posEnd != null) {
            GlStateManager.func_187441_d((float)3.0f);
            aabb = BuildersWandRenderer.createAABB(posEnd.getX(), posEnd.getY(), posEnd.getZ(), 0.0, partialTicks, clientPlayer);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)0.06666667f, (float)0.06666667f, (float)1.0f, (float)1.0f);
        }
    }

    private void updatePositions(EntityPlayer usingPlayer, BlockPosEU posStart, BlockPosEU posEnd) {
        int i;
        if (posStart == null && posEnd == null) {
            this.positions.clear();
            return;
        }
        if (posStart == null) {
            posStart = posEnd;
            posEnd = new BlockPosEU((int)usingPlayer.field_70165_t, (int)usingPlayer.field_70163_u, (int)usingPlayer.field_70161_v, usingPlayer.field_71093_bK, EnumFacing.UP);
        } else if (posEnd == null) {
            posEnd = new BlockPosEU((int)usingPlayer.field_70165_t, (int)usingPlayer.field_70163_u, (int)usingPlayer.field_70161_v, usingPlayer.field_71093_bK, EnumFacing.UP);
        }
        BlockPosEU[] pos = new BlockPosEU[]{posStart, posEnd};
        int[] done = new int[]{0, 0, 0};
        for (i = 0; i < 3; ++i) {
            BlockPosAligner aligner = new BlockPosAligner(pos[0], pos[1], usingPlayer);
            BlockPosEU aligned = aligner.getAlignedPointAlongLongestAxis();
            int furthest = aligner.furthestPoint;
            if (aligner.axisLength > 0) {
                boolean includeStart = !aligned.equals(pos[0]) && !aligned.equals(pos[1]);
                this.positions.put(aligner.longestAxis, this.getColumn(aligned, pos[furthest], aligner.longestAxis, includeStart, false));
                done[aligner.longestAxis] = 1;
            }
            pos[furthest] = aligned;
        }
        for (i = 0; i < 3; ++i) {
            if (done[i] != 0) continue;
            this.positions.remove(i);
        }
    }

    private List<BlockPosEU> getColumn(BlockPosEU posNear, BlockPosEU posFar, int axis, boolean includeStart, boolean includeEnd) {
        ArrayList<BlockPosEU> list;
        block5: {
            int maxLength;
            int[] p2;
            int[] p1;
            block4: {
                int inc;
                list = new ArrayList<BlockPosEU>();
                p1 = new int[]{posNear.getX(), posNear.getY(), posNear.getZ()};
                p2 = new int[]{posFar.getX(), posFar.getY(), posFar.getZ()};
                int n = inc = p1[axis] < p2[axis] ? 1 : -1;
                if (!includeStart) {
                    int n2 = axis;
                    p1[n2] = p1[n2] + inc;
                }
                if (!includeEnd) {
                    int n3 = axis;
                    p2[n3] = p2[n3] - inc;
                }
                maxLength = 160;
                if (p1[axis] > p2[axis]) break block4;
                for (int i = 0; i < maxLength && p1[axis] <= p2[axis]; ++i) {
                    list.add(new BlockPosEU(p1[0], p1[1], p1[2], posNear.getDimension(), posNear.getFacing()));
                    int n4 = axis;
                    p1[n4] = p1[n4] + 1;
                }
                break block5;
            }
            if (p1[axis] <= p2[axis]) break block5;
            for (int i = 0; i < maxLength && p1[axis] >= p2[axis]; ++i) {
                list.add(new BlockPosEU(p1[0], p1[1], p1[2], posNear.getDimension(), posNear.getFacing()));
                int n = axis;
                p1[n] = p1[n] - 1;
            }
        }
        return list;
    }

    private class BlockPosAligner {
        public final double[] playerPos;
        public int longestAxis;
        public int axisLength;
        public int furthestPoint;
        public int[][] points;

        public BlockPosAligner(BlockPosEU p1, BlockPosEU p2, EntityPlayer player) {
            this.playerPos = new double[]{player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v};
            this.points = new int[][]{{p1.getX(), p1.getY(), p1.getZ()}, {p2.getX(), p2.getY(), p2.getZ()}};
        }

        public int getLongestAxis() {
            int longest = 0;
            int length = Math.abs(this.points[0][0] - this.points[1][0]);
            for (int i = 1; i < 3; ++i) {
                int tmp = Math.abs(this.points[0][i] - this.points[1][i]);
                if (tmp <= length) continue;
                longest = i;
                length = tmp;
            }
            this.longestAxis = longest;
            this.axisLength = length;
            return longest;
        }

        public int getFurthestPointIndexOnLongestAxis() {
            double len1;
            int axisId = this.getLongestAxis();
            double len0 = Math.abs(this.playerPos[axisId] - ((double)this.points[0][axisId] + 0.5));
            this.furthestPoint = len0 > (len1 = Math.abs(this.playerPos[axisId] - ((double)this.points[1][axisId] + 0.5))) ? 0 : 1;
            return this.furthestPoint;
        }

        public BlockPosEU getAlignedPointAlongLongestAxis() {
            int far = this.getFurthestPointIndexOnLongestAxis();
            int near = far ^ 1;
            int[] p = new int[]{this.points[far][0], this.points[far][1], this.points[far][2]};
            p[this.longestAxis] = this.points[near][this.longestAxis];
            return new BlockPosEU(p[0], p[1], p[2]);
        }
    }
}

