/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event.tasks;

import fi.dy.masa.enderutilities.event.tasks.IPlayerTask;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.TemplateEnderUtilities;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class TaskStackArea
implements IPlayerTask {
    protected final int dimension;
    protected final UUID wandUUID;
    protected final BlockPos posOrig;
    protected final Vec3i sizeAbs;
    protected final TemplateEnderUtilities template;
    protected final ItemBuildersWand.Area3D area;
    protected final int blocksPerTick;
    protected final int templateNumBlocks;
    protected Vec3i currentArea;
    protected BlockPos currentStartPos;
    protected int listIndex = 0;
    protected int placedCount = 0;
    protected int failCount = 0;

    public TaskStackArea(World world, UUID wandUUID, BlockPos posOrig, BlockPos endPosRelative, TemplateEnderUtilities template, ItemBuildersWand.Area3D area, int blocksPerTick) {
        this.dimension = world.field_73011_w.getDimension();
        this.wandUUID = wandUUID;
        this.posOrig = posOrig;
        this.sizeAbs = new Vec3i(Math.abs(endPosRelative.func_177958_n()) + 1, Math.abs(endPosRelative.func_177956_o()) + 1, Math.abs(endPosRelative.func_177952_p()) + 1);
        this.template = template;
        this.templateNumBlocks = template.getBlockList().size();
        this.area = area;
        this.blocksPerTick = blocksPerTick;
        this.currentArea = new Vec3i(-area.getXNeg(), -area.getYNeg(), -area.getZNeg());
        if (this.currentArea.func_177958_n() == 0 && this.currentArea.func_177956_o() == 0 && this.currentArea.func_177952_p() == 0) {
            this.incrementArea();
        }
        this.currentStartPos = this.getStartPos();
    }

    protected BlockPos getStartPos() {
        return this.posOrig.func_177982_a(this.currentArea.func_177958_n() * this.sizeAbs.func_177958_n(), this.currentArea.func_177956_o() * this.sizeAbs.func_177956_o(), this.currentArea.func_177952_p() * this.sizeAbs.func_177952_p());
    }

    protected boolean incrementArea() {
        int x = this.currentArea.func_177958_n();
        int y = this.currentArea.func_177956_o();
        int z = this.currentArea.func_177952_p();
        if (++x > this.area.getXPos()) {
            x = this.area.getXNeg();
            if (++z > this.area.getZPos()) {
                z = this.area.getZNeg();
                ++y;
            }
        }
        this.currentArea = new Vec3i(x, y, z);
        this.currentStartPos = this.getStartPos();
        if (y > this.area.getYPos()) {
            return false;
        }
        if (x == 0 && y == 0 && z == 0) {
            this.incrementArea();
        }
        return true;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canExecute(World world, EntityPlayer player) {
        return world.field_73011_w.getDimension() == this.dimension && this.currentArea.func_177956_o() <= this.area.getYPos();
    }

    @Override
    public boolean execute(World world, EntityPlayer player) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.BUILDERS_WAND);
        if (!stack.func_190926_b() && this.wandUUID.equals(NBTUtils.getUUIDFromItemStack(stack, "BuildersWand", false))) {
            ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
            PlacementSettings placement = this.template.getPlacementSettings();
            int placedThisTick = 0;
            while (placedThisTick < this.blocksPerTick && this.listIndex < this.templateNumBlocks) {
                TemplateEnderUtilities.TemplateBlockInfo blockInfo = this.template.getBlockList().get(this.listIndex);
                IBlockState state = blockInfo.blockState.func_185902_a(placement.func_186212_b()).func_185907_a(placement.func_186215_c());
                BlockPos pos = TemplateEnderUtilities.transformedBlockPos(placement, blockInfo.pos).func_177971_a((Vec3i)this.currentStartPos);
                if (wand.placeBlockToPosition(stack, world, player, pos, EnumFacing.UP, state, 2, true, true)) {
                    ++this.placedCount;
                    this.failCount = 0;
                    ++placedThisTick;
                }
                ++this.listIndex;
                if (this.listIndex < this.templateNumBlocks) continue;
                this.listIndex = 0;
                if (this.incrementArea()) continue;
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_189107_dL, SoundCategory.BLOCKS, 0.6f, 1.0f);
                return true;
            }
        } else {
            ++this.failCount;
        }
        if (this.failCount > 200) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 0.6f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
    }
}

