/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client;

import fi.dy.masa.enderutilities.gui.client.base.GuiArea;
import fi.dy.masa.enderutilities.gui.client.base.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.base.ScrollBar;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonHoverText;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonStateCallback;
import fi.dy.masa.enderutilities.gui.client.button.IButtonStateCallback;
import fi.dy.masa.enderutilities.inventory.container.ContainerSoundBlock;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.tileentity.TileEntitySoundBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiSoundBlock
extends GuiEnderUtilities
implements IButtonStateCallback {
    private final TileEntitySoundBlock tesb;
    private final List<Pair<Integer, String>> allSounds = new ArrayList<Pair<Integer, String>>();
    private final List<Pair<Integer, String>> filteredSounds = new ArrayList<Pair<Integer, String>>();
    private final ScrollBar scrollBar;
    private final GuiArea areaSoundList;
    private GuiTextField searchField;
    private int startIndex;
    private String selectedName = "";

    public GuiSoundBlock(ContainerSoundBlock container, TileEntitySoundBlock te) {
        super(container, 176, 256, "gui.container." + te.getTEName());
        this.tesb = te;
        this.scrollBar = new ScrollBar(0, 152, 38, 212, 0, 12, 98, 0, this, this.guiTexture);
        this.areaSoundList = new GuiArea(8, 38, 142, 98);
        this.infoArea = new GuiEnderUtilities.InfoArea(160, 5, 11, 11, "enderutilities.gui.infoarea.sound_block", new Object[0]);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.createButtons();
        this.initSearchField(this.tesb.filter);
        this.initSoundList();
        this.applyFilterString();
        this.selectedName = this.getSoundName(this.tesb.selectedSound);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.container.sound_block", (Object[])new Object[0]), 8, 6, 0x404040);
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        this.searchField.func_146194_f();
        int max = Math.min(this.filteredSounds.size() - 1, this.startIndex + 9);
        int h = this.field_146289_q.field_78288_b + 1;
        int i = 0;
        int index = this.startIndex;
        while (index <= max) {
            String str = (String)this.filteredSounds.get(index).getRight();
            str = str.substring(0, Math.min(27, str.length()));
            int color = (Integer)this.filteredSounds.get(index).getLeft() == this.tesb.selectedSound ? 0xF0F0F0 : 0x202020;
            this.field_146289_q.func_78276_b(str, this.areaSoundList.getX() + 2, this.areaSoundList.getY() + 1 + i * h, color);
            ++index;
            ++i;
        }
        if (!StringUtils.isEmpty((CharSequence)this.selectedName)) {
            this.field_146289_q.func_78276_b(this.selectedName, 8, 140, 0x404040);
        }
        String str = I18n.func_135052_a((String)"enderutilities.gui.label.sound_block.pitch", (Object[])new Object[0]) + String.format(": %.3f", Float.valueOf(this.tesb.getPitch()));
        this.field_146289_q.func_78276_b(str, 60, 152, 0x404040);
        str = I18n.func_135052_a((String)"enderutilities.gui.label.sound_block.volume", (Object[])new Object[0]) + String.format(": %.3f", Float.valueOf(this.tesb.getVolume()));
        this.field_146289_q.func_78276_b(str, 60, 163, 0x404040);
    }

    @Override
    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        super.func_146976_a(gameTicks, mouseX, mouseY);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollBar.render(x, y, mouseX, mouseY);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void initSearchField(String str) {
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(0, this.field_146289_q, 8, 26, 141, 12);
        this.searchField.func_146193_g(-1);
        this.searchField.func_146204_h(-1);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(50);
        this.searchField.func_146184_c(true);
        this.searchField.func_146180_a(str);
        this.searchField.func_146195_b(false);
    }

    private void initSoundList() {
        this.allSounds.clear();
        for (Map.Entry entry : ForgeRegistries.SOUND_EVENTS.getEntries()) {
            int id = SoundEvent.field_187505_a.func_148757_b(entry.getValue());
            this.allSounds.add((Pair<Integer, String>)Pair.of((Object)id, (Object)((ResourceLocation)entry.getKey()).toString()));
        }
    }

    private void applyFilterString() {
        String filter;
        this.tesb.filter = filter = this.searchField.func_146179_b();
        this.filteredSounds.clear();
        if (StringUtils.isEmpty((CharSequence)filter)) {
            this.filteredSounds.addAll(this.allSounds);
        } else {
            for (Pair<Integer, String> pair : this.allSounds) {
                if (!((String)pair.getRight()).contains(filter)) continue;
                this.filteredSounds.add(pair);
            }
        }
        Collections.sort(this.filteredSounds);
        this.updateScrollbarScaling(this.filteredSounds.size());
    }

    private void updateScrollbarScaling(int listSize) {
        this.scrollBar.setPositionCount(listSize - 9);
        this.scrollBar.handleMouseInput(0, 0);
        this.startIndex = this.scrollBar.getPosition();
        if (this.startIndex >= this.filteredSounds.size() - 9) {
            this.startIndex = 0;
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            this.applyFilterString();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 1 && mouseX >= this.field_147003_i + this.searchField.field_146209_f && mouseX < this.field_147003_i + this.searchField.field_146209_f + this.searchField.field_146218_h && mouseY >= this.field_147009_r + this.searchField.field_146210_g && mouseY < this.field_147009_r + this.searchField.field_146210_g + this.searchField.field_146219_i) {
            this.searchField.func_146180_a("");
            this.searchField.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
            this.applyFilterString();
        } else {
            int mouseYA;
            int mouseXA = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
            if (this.areaSoundList.isMouseOver(mouseXA, mouseYA = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r)) {
                this.handleClickOnListEntry(mouseXA, mouseYA);
            } else {
                super.func_73864_a(mouseX, mouseY, mouseButton);
                this.searchField.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
            }
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r;
        if (Mouse.getEventDWheel() != 0 && (this.areaSoundList.isMouseOver(mouseX, mouseY) || this.scrollBar.isMouseOver(mouseX, mouseY))) {
            this.scrollBar.handleMouseInput(mouseX, mouseY);
        } else if (Mouse.getEventButton() != 0 && !Mouse.isButtonDown((int)0) || !this.scrollBar.handleMouseInput(mouseX, mouseY)) {
            super.func_146274_d();
        }
    }

    @Override
    public void scrollbarAction(int scrollbarId, ScrollBar.ScrollbarAction action, int position) {
        this.startIndex = this.scrollBar.getPosition();
    }

    private String getSoundName(int id) {
        SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_148754_a(id);
        return sound != null ? sound.getRegistryName().toString() : "";
    }

    private int getSoundId(int listIndex) {
        if (listIndex >= 0 && listIndex < this.filteredSounds.size()) {
            Pair<Integer, String> pair = this.filteredSounds.get(listIndex);
            return pair != null ? (Integer)pair.getLeft() : -1;
        }
        return -1;
    }

    private void handleClickOnListEntry(int mouseX, int mouseY) {
        int y = mouseY - this.areaSoundList.getY();
        int index = 10 * y / this.areaSoundList.getHeight() + this.startIndex;
        this.tesb.selectedSound = this.getSoundId(index);
        this.selectedName = this.tesb.selectedSound >= 0 ? this.getSoundName(this.tesb.selectedSound) : "";
        int dim = this.player.func_130014_f_().field_73011_w.getDimension();
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(dim, this.tesb.func_174877_v(), 0, 1000, this.tesb.selectedSound));
    }

    protected void createButtons() {
        this.field_146292_n.clear();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButtonStateCallback(0, x + 38, y + 152, 8, 8, 8, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(0, 40, "enderutilities.gui.label.sound_block.repeat.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(0, 88, "enderutilities.gui.label.sound_block.repeat.enabled")));
        this.field_146292_n.add(new GuiButtonHoverText(1, x + 49, y + 152, 8, 8, 0, 120, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.sound_block.pitch"));
        this.field_146292_n.add(new GuiButtonHoverText(2, x + 49, y + 163, 8, 8, 0, 120, this.guiTextureWidgets, 8, 0, "enderutilities.gui.label.sound_block.volume"));
        this.field_146292_n.add(new GuiButtonHoverText(10, x + 8, y + 152, 12, 12, 176, 0, this.guiTexture, 12, 0, "enderutilities.gui.label.sound_block.play"));
        this.field_146292_n.add(new GuiButtonHoverText(11, x + 23, y + 152, 12, 12, 176, 24, this.guiTexture, 12, 0, "enderutilities.gui.label.sound_block.stop"));
        this.field_146292_n.add(new GuiButtonHoverText(20, x + 152, y + 24, 12, 12, 176, 48, this.guiTexture, 12, 0, "enderutilities.gui.label.sound_block.clear"));
    }

    @Override
    protected void actionPerformedWithButton(GuiButton button, int mouseButton) throws IOException {
        int dim = this.player.func_130014_f_().field_73011_w.getDimension();
        int amount = 0;
        if (mouseButton == 0 || mouseButton == 11) {
            amount = 1;
        } else if (mouseButton == 1 || mouseButton == 9) {
            amount = -1;
        }
        if (button.field_146127_k == 1 || button.field_146127_k == 2) {
            if (GuiScreen.func_146272_n()) {
                amount *= 10;
            }
            if (GuiScreen.func_146271_m()) {
                amount *= 100;
            }
        }
        if (button.field_146127_k == 20) {
            this.searchField.func_146180_a("");
            this.applyFilterString();
        } else {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(dim, this.tesb.func_174877_v(), 0, button.field_146127_k, amount));
        }
    }

    @Override
    public int getButtonStateIndex(int callbackId) {
        if (callbackId == 0) {
            return this.tesb.getRepeat() ? 1 : 0;
        }
        return 0;
    }

    @Override
    public boolean isButtonEnabled(int callbackId) {
        return true;
    }
}

