/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import com.google.common.base.Optional;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.event.EntityEventHandler;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.MethodHandleUtils;
import fi.dy.masa.enderutilities.util.TileUtils;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BlockUtils {
    public static final Pattern PATTERN_BLOCK_STATE_STRING = Pattern.compile("(?<name>([a-z0-9_]+:)?[a-z0-9\\._]+)\\[(?<props>[a-z0-9_]+=[a-z0-9_]+(,[a-z0-9_]+=[a-z0-9_]+)*)\\]");
    private static MethodHandle methodHandle_Block_getSilkTouchDrop;

    public static Set<IBlockState> getMatchingBlockStatesForString(String blockStateString) {
        HashSet<IBlockState> validStates = new HashSet<IBlockState>();
        ResourceLocation air = new ResourceLocation("minecraft:air");
        int index = blockStateString.indexOf(91);
        String name = index > 0 ? blockStateString.substring(0, index) : blockStateString;
        ResourceLocation key = new ResourceLocation(name);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
        if (block != null && (block != Blocks.field_150350_a || key.equals((Object)air))) {
            Object statesTmp = block.func_176194_O().func_177619_a();
            List<Pair<String, String>> props = BlockUtils.getBlockStatePropertiesFromString(blockStateString);
            if (!props.isEmpty()) {
                for (Pair<String, String> pair : props) {
                    statesTmp = BlockUtils.getFilteredStates((Collection<IBlockState>)statesTmp, (String)pair.getLeft(), (String)pair.getRight());
                }
            }
            validStates.addAll((Collection<IBlockState>)statesTmp);
        } else {
            EnderUtilities.logger.warn("BlockUtils.getMatchingBlockStatesForString(): Invalid block state string '{}'", (Object)blockStateString);
        }
        return validStates;
    }

    public static List<Pair<String, String>> getBlockStatePropertiesFromString(String blockStateString) {
        Matcher matcherNameProps = PATTERN_BLOCK_STATE_STRING.matcher(blockStateString);
        if (matcherNameProps.matches()) {
            ArrayList<Pair<String, String>> props = new ArrayList<Pair<String, String>>();
            String propStr = matcherNameProps.group("props");
            String[] propParts = propStr.split(",");
            Pattern patternProp = Pattern.compile("(?<prop>[a-zA-Z0-9\\._-]+)=(?<value>[a-zA-Z0-9\\._-]+)");
            for (int i = 0; i < propParts.length; ++i) {
                Matcher matcherProp = patternProp.matcher(propParts[i]);
                if (matcherProp.matches()) {
                    props.add((Pair<String, String>)Pair.of((Object)matcherProp.group("prop"), (Object)matcherProp.group("value")));
                    continue;
                }
                EnderUtilities.logger.warn("BlockUtils.getBlockStatePropertiesFromString(): Invalid block property '{}'", (Object)propParts[i]);
            }
            Collections.sort(props);
            return props;
        }
        return Collections.emptyList();
    }

    public static <T extends Comparable<T>> List<IBlockState> getFilteredStates(Collection<IBlockState> initialStates, String propName, String propValue) {
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        for (IBlockState state : initialStates) {
            Optional value;
            IProperty prop = state.func_177230_c().func_176194_O().func_185920_a(propName);
            if (prop == null || !(value = prop.func_185929_b(propValue)).isPresent() || !state.func_177229_b(prop).equals(value.get())) continue;
            list.add(state);
        }
        return list;
    }

    public static void breakBlockAsPlayer(World world, BlockPos pos, EntityPlayerMP playerMP, ItemStack toolStack) {
        PlayerInteractionManager manager = playerMP.field_71134_c;
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)manager.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos);
        if (exp != -1) {
            IBlockState stateExisting = world.func_180495_p(pos);
            Block blockExisting = stateExisting.func_177230_c();
            blockExisting.func_176208_a(world, pos, stateExisting, (EntityPlayer)playerMP);
            boolean harvest = blockExisting.removedByPlayer(stateExisting, world, pos, (EntityPlayer)playerMP, true);
            if (harvest) {
                blockExisting.func_176206_d(world, pos, stateExisting);
                blockExisting.func_180657_a(world, (EntityPlayer)playerMP, pos, stateExisting, world.func_175625_s(pos), toolStack);
            }
        }
    }

    public static boolean canChangeBlock(World world, BlockPos pos, EntityPlayer player, boolean allowTileEntities, float maxHardness) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            return true;
        }
        float hardness = state.func_185887_b(world, pos);
        return world.func_175660_a(player, pos) && hardness >= 0.0f && (hardness <= maxHardness || state.func_185904_a().func_76224_d()) && (allowTileEntities || world.func_175625_s(pos) == null);
    }

    public static void getDropAndSetToAir(World world, EntityPlayer player, BlockPos pos, EnumFacing side, boolean addToInventory) {
        ItemStack stack;
        if (!player.field_71075_bZ.field_75098_d && !(stack = BlockUtils.getPickBlockItemStack(world, pos, player, side)).func_190926_b()) {
            IItemHandler inv;
            if (addToInventory && (inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                stack = InventoryUtils.tryInsertItemStackToInventory(inv, stack);
            }
            if (!stack.func_190926_b()) {
                EntityUtils.dropItemStacksInWorld(world, pos, stack, -1, true);
            }
        }
        BlockUtils.setBlockToAirWithBreakSound(world, pos);
    }

    public static void setBlockToAirWithBreakSound(World world, BlockPos pos) {
        BlockUtils.playBlockBreakSound(world, pos);
        world.func_175698_g(pos);
    }

    public static void playBlockBreakSound(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        SoundType soundtype = state.func_177230_c().getSoundType(state, world, pos, null);
        world.func_184133_a(null, pos, soundtype.func_185845_c(), SoundCategory.BLOCKS, soundtype.func_185843_a(), soundtype.func_185847_b());
    }

    public static void setBlockToAirWithoutSpillingContents(World world, BlockPos pos) {
        BlockUtils.setBlockToAirWithoutSpillingContents(world, pos, 3);
    }

    public static void setBlockToAirWithoutSpillingContents(World world, BlockPos pos, int flags) {
        EntityEventHandler.setPreventEntitySpawning(true);
        world.restoringBlockSnapshots = true;
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), flags);
        world.restoringBlockSnapshots = false;
        EntityEventHandler.setPreventEntitySpawning(false);
    }

    public static boolean setBlockStateWithPlaceSound(World world, BlockPos pos, IBlockState newState, int setBlockStateFlags) {
        boolean success = world.func_180501_a(pos, newState, setBlockStateFlags);
        if (success) {
            SoundType soundtype = newState.func_177230_c().getSoundType(newState, world, pos, null);
            world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        }
        return success;
    }

    public static ItemStack getPickBlockItemStack(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        return BlockUtils.getPickBlockItemStack(world, pos, world.func_180495_p(pos), player, side);
    }

    public static ItemStack getPickBlockItemStack(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side) {
        IBlockState existingState = world.func_180495_p(pos);
        NBTTagCompound nbt = null;
        boolean replaced = false;
        if (existingState.func_177230_c() != state.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                nbt = te.func_189515_b(new NBTTagCompound());
                te.onChunkUnload();
            }
            BlockUtils.setBlockToAirWithoutSpillingContents(world, pos, 4);
            world.func_180501_a(pos, state, 4);
            replaced = true;
        }
        RayTraceResult trace = new RayTraceResult(new Vec3d((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5), side, pos);
        ItemStack stack = state.func_177230_c().getPickBlock(state, trace, world, pos, player);
        if (replaced) {
            BlockUtils.setBlockToAirWithoutSpillingContents(world, pos, 4);
            world.func_180501_a(pos, existingState, 4);
            if (nbt != null) {
                TileUtils.createAndAddTileEntity(world, pos, nbt);
            }
        }
        return stack;
    }

    public static ItemStack getSilkTouchDrop(World world, BlockPos pos) {
        return BlockUtils.getSilkTouchDrop(world.func_180495_p(pos));
    }

    public static ItemStack getSilkTouchDrop(IBlockState state) {
        Block block = state.func_177230_c();
        ItemStack stack = ItemStack.field_190927_a;
        try {
            stack = methodHandle_Block_getSilkTouchDrop.invokeExact(block, state);
        }
        catch (Throwable t) {
            EnderUtilities.logger.warn("Error while trying invoke Block#getSilkTouchDrop() from {} via a MethodHandle", (Object)block.getClass().getName(), (Object)t);
        }
        return stack;
    }

    public static boolean checkCanPlaceBlockAt(World world, BlockPos pos, EnumFacing side, Block blockNew) {
        Block blockExisting = world.func_180495_p(pos).func_177230_c();
        if (blockExisting == Blocks.field_150431_aC && blockExisting.func_176200_f((IBlockAccess)world, pos)) {
            side = EnumFacing.UP;
        } else if (!blockExisting.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        return world.func_190527_a(blockNew, pos, false, side, (Entity)null);
    }

    static {
        try {
            methodHandle_Block_getSilkTouchDrop = MethodHandleUtils.getMethodHandleVirtual(Block.class, new String[]{"func_180643_i", "getSilkTouchDrop"}, IBlockState.class);
        }
        catch (MethodHandleUtils.UnableToFindMethodHandleException e) {
            EnderUtilities.logger.error("BlockUtils: Failed to get a MethodHandle for Block#getSilkTouchDrop()", (Throwable)e);
        }
    }
}

