/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.model;

import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.ChamRenderState;
import com.jaquadro.minecraft.chameleon.render.helpers.ModularBoxRenderer;
import com.jaquadro.minecraft.chameleon.render.helpers.PanelBoxRenderer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ForkedDrawerRenderer {
    private static double lessThanHalf = 0.4375;
    private static double moreThanHalf = 0.5625;
    private final ChamRender renderHelper;
    private final PanelBoxRenderer panelRenderer;
    private double trimWidth;
    private double trimDepth;

    public ForkedDrawerRenderer(ChamRender renderer) {
        this.renderHelper = renderer;
        this.panelRenderer = new PanelBoxRenderer(renderer);
    }

    private void start(IBlockState state, EnumFacing direction) {
        BlockDrawers block = (BlockDrawers)state.func_177230_c();
        StatusModelData status = block.getStatusInfo(state);
        this.trimWidth = 0.0625;
        this.trimDepth = status.getFrontDepth() / 16.0;
        lessThanHalf = 0.4375;
        moreThanHalf = 0.5625;
        this.panelRenderer.setTrimWidth(this.trimWidth);
        this.panelRenderer.setTrimDepth(0.0);
        this.panelRenderer.setTrimColor(ModularBoxRenderer.COLOR_WHITE);
        this.panelRenderer.setPanelColor(ModularBoxRenderer.COLOR_WHITE);
        this.renderHelper.state.setRotateTransform(2, direction.func_176745_a());
        this.renderHelper.state.setUVRotation(1, ChamRenderState.ROTATION_BY_FACE_FACE[2][direction.func_176745_a()]);
    }

    private void end() {
        this.renderHelper.state.clearRotateTransform();
        this.renderHelper.state.clearUVRotation(1);
    }

    public void renderBasePass(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing direction, TextureAtlasSprite iconSide, TextureAtlasSprite iconTrim, TextureAtlasSprite iconFront) {
        this.start(state, direction);
        this.panelRenderer.setTrimIcon(iconTrim);
        this.panelRenderer.setPanelIcon(iconSide);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir != ChamRender.FACE_ZNEG) {
                this.renderHelper.targetFaceGroup(true);
                this.panelRenderer.renderFacePanel(dir, world, state, pos, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            } else {
                this.renderHelper.targetFaceGroup(true);
            }
            this.panelRenderer.renderFaceTrim(dir, world, state, pos, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.renderHelper.targetFaceGroup(false);
        }
        this.panelRenderer.setTrimDepth(this.trimDepth);
        this.panelRenderer.renderInteriorTrim(ChamRender.FACE_ZNEG, world, state, pos, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.renderHelper.state.flipTexture = true;
        this.renderHelper.state.autoFlipTexture = true;
        this.renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.trimDepth, lessThanHalf, lessThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
        this.renderHelper.setRenderBounds(this.trimWidth, moreThanHalf, this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
        this.renderHelper.setRenderBounds(moreThanHalf, this.trimWidth, this.trimDepth, 1.0 - this.trimWidth, lessThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconFront);
        this.renderHelper.setRenderBounds(this.trimWidth, lessThanHalf, this.trimDepth, lessThanHalf, moreThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
        this.renderHelper.setRenderBounds(moreThanHalf, lessThanHalf, this.trimDepth, 1.0 - this.trimWidth, moreThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
        this.renderHelper.setRenderBounds(lessThanHalf, this.trimWidth, this.trimDepth, moreThanHalf, lessThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
        this.renderHelper.setRenderBounds(lessThanHalf, lessThanHalf, this.trimDepth, moreThanHalf, moreThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, iconTrim);
        this.renderHelper.state.autoFlipTexture = false;
        this.renderHelper.state.flipTexture = false;
        this.end();
    }

    public void renderOverlayPass(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing direction, TextureAtlasSprite trimShadow, TextureAtlasSprite handle, TextureAtlasSprite faceShadow, TextureAtlasSprite disabledSlots) {
        this.start(state, direction);
        this.panelRenderer.setTrimIcon(trimShadow);
        this.renderHelper.targetFaceGroup(true);
        this.panelRenderer.renderFaceTrim(ChamRender.FACE_ZNEG, world, state, pos, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.renderHelper.targetFaceGroup(false);
        this.renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.trimDepth, lessThanHalf, lessThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, disabledSlots);
        this.renderHelper.setRenderBounds(this.trimWidth, moreThanHalf, this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, disabledSlots);
        this.renderHelper.setRenderBounds(moreThanHalf, this.trimWidth, this.trimDepth, 1.0 - this.trimWidth, lessThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, handle);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, faceShadow);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, disabledSlots);
        this.renderHelper.setRenderBounds(this.trimWidth, lessThanHalf, this.trimDepth, lessThanHalf, moreThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
        this.renderHelper.setRenderBounds(moreThanHalf, lessThanHalf, this.trimDepth, 1.0 - this.trimWidth, moreThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
        this.renderHelper.setRenderBounds(lessThanHalf, this.trimWidth, this.trimDepth, moreThanHalf, lessThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
        this.renderHelper.setRenderBounds(lessThanHalf, lessThanHalf, this.trimDepth, moreThanHalf, moreThanHalf, 1.0);
        this.renderHelper.renderFace(ChamRender.FACE_ZNEG, world, state, pos, trimShadow);
        this.end();
    }
}

