/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.init.LCItems;
import sblectric.lightningcraft.items.ItemBattery;
import sblectric.lightningcraft.ref.LCText;
import sblectric.lightningcraft.util.IntList;
import sblectric.lightningcraft.util.LCMisc;
import sblectric.lightningcraft.util.SkyUtils;

public class InventoryLE {
    public static final double repairSpeedModifier = 2.25;
    public static final double breakUsage = 0.2;
    public static final double energyUsage = 0.02;
    public static final double strikeUsage = 0.2;

    @SideOnly(value=Side.CLIENT)
    public static boolean addInformation(@Nonnull ItemStack stack, World world, List list, ITooltipFlag flag, LECharge charge) {
        list.add(LCText.getInventoryLEUserLore());
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean charged = InventoryLE.hasLESource((EntityPlayer)player);
        charge.setCharge(InventoryLE.getAvailablePower((EntityPlayer)player));
        String lpLore = "\u00a7" + (charged ? (charge.getCharge() > 0.0 ? "b" + LCText.df.format(charge.getCharge()) : "cNo") + " LE available" : "cNo LE Source Found");
        list.add(lpLore);
        return charged;
    }

    public static double getAvailablePower(EntityPlayer user) {
        if (InventoryLE.hasLESource(user)) {
            int invPos = 0;
            double power = 0.0;
            IntList avoid = new IntList();
            while ((invPos = LCMisc.posInInventory(user, LCItems.battery, avoid)) >= 0) {
                if (invPos < 0) continue;
                ItemStack battery = (ItemStack)user.field_71071_by.field_70462_a.get(invPos);
                power = Math.max(power, ItemBattery.getStoredPower(battery));
                avoid.add(invPos);
            }
            return power;
        }
        return 0.0;
    }

    public static boolean hasLESource(EntityPlayer user) {
        return user != null && LCMisc.posInInventory(user, LCItems.battery) >= 0;
    }

    @Nonnull
    public static ItemStack getLESource(EntityPlayer user, double lpNeeded) {
        if (InventoryLE.hasLESource(user)) {
            int invPos = 0;
            IntList avoid = new IntList();
            while ((invPos = LCMisc.posInInventory(user, LCItems.battery, avoid)) >= 0) {
                if (invPos < 0) continue;
                ItemStack battery = (ItemStack)user.field_71071_by.field_70462_a.get(invPos);
                if (ItemBattery.getStoredPower(battery) >= lpNeeded) {
                    return battery;
                }
                avoid.add(invPos);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static void hitEntity(@Nonnull ItemStack stack, EntityLivingBase entity, EntityLivingBase user, double normalDamage, boolean maxDamage) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            DamageSource source = DamageSource.func_76365_a((EntityPlayer)player);
            float damage = 0.0f;
            double charge = InventoryLE.getAvailablePower(player);
            boolean sneaking = player.func_70093_af() && maxDamage;
            damage = !sneaking ? (float)Math.min(charge, normalDamage) : (float)Math.min(charge, 50.0);
            if (damage > 0.0f) {
                double cost = (double)damage * 0.2;
                ItemStack battery = InventoryLE.getLESource(player, cost);
                ItemBattery.addStoredPower(battery, -cost);
            }
            entity.func_70097_a(source, damage);
        }
    }

    public static float getEfficiency(@Nonnull ItemStack tool, float baseEff) {
        double charge = tool.func_77942_o() ? tool.func_77978_p().func_74769_h("availablePower") : 0.0;
        double multiplier = (LCItems.mysticMat.func_77998_b() - 2.0f) / baseEff;
        double take = Math.min(charge / 0.2, multiplier);
        float newEff = charge > 0.0 ? baseEff * (float)take : baseEff;
        return newEff;
    }

    public static void updateToolPower(@Nonnull ItemStack tool, EntityPlayer player) {
        if (!tool.func_77942_o()) {
            tool.func_77982_d(new NBTTagCompound());
        }
        if (SkyUtils.canWriteItemNBT(tool, player) && tool.func_77978_p().func_74769_h("availablePower") != InventoryLE.getAvailablePower(player)) {
            tool.func_77978_p().func_74780_a("availablePower", InventoryLE.getAvailablePower(player));
        }
    }

    public static void onBlockBreak(@Nonnull ItemStack tool, EntityPlayer player, float baseEff) {
        double charge = InventoryLE.getAvailablePower(player);
        double multiplier = (LCItems.mysticMat.func_77998_b() - 2.0f) / baseEff;
        double take = Math.min(charge, multiplier) * 0.02;
        ItemStack battery = InventoryLE.getLESource(player, take);
        ItemBattery.addStoredPower(battery, -take);
        tool.func_77978_p().func_74780_a("availablePower", InventoryLE.getAvailablePower(player));
    }

    public static class LECharge {
        private double power;

        public LECharge(double charge) {
            this.power = charge;
        }

        public LECharge() {
            this.power = 0.0;
        }

        public double getCharge() {
            return this.power;
        }

        public void setCharge(double charge) {
            this.power = charge;
        }
    }
}

