/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.PreparedRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementFluid;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementItem;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.util.LinkedList;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.modularmachinery.RecipePrimer")
public class RecipePrimer
implements PreparedRecipe {
    private final ResourceLocation name;
    private final ResourceLocation machineName;
    private final int tickTime;
    private final int priority;
    private List<ComponentRequirement> components = new LinkedList<ComponentRequirement>();
    private ComponentRequirement lastComponent = null;

    public RecipePrimer(ResourceLocation registryName, ResourceLocation owningMachine, int tickTime, int configuredPriority) {
        this.name = registryName;
        this.machineName = owningMachine;
        this.tickTime = tickTime;
        this.priority = configuredPriority;
    }

    @ZenMethod
    public RecipePrimer setChance(float chance) {
        if (this.lastComponent != null) {
            if (this.lastComponent instanceof ComponentRequirement.ChancedRequirement) {
                ((ComponentRequirement.ChancedRequirement)((Object)this.lastComponent)).setChance(chance);
            } else {
                CraftTweakerAPI.logWarning((String)("Cannot set chance for not-chance-based Component: " + this.lastComponent.getClass().toString()));
            }
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer setTag(String selectorTag) {
        if (this.lastComponent != null) {
            this.lastComponent.setTag(new ComponentSelectorTag(selectorTag));
        }
        return this;
    }

    @ZenMethod
    public RecipePrimer addEnergyPerTickInput(int perTick) {
        this.requireEnergy(MachineComponent.IOType.INPUT, perTick);
        return this;
    }

    @ZenMethod
    public RecipePrimer addEnergyPerTickOutput(int perTick) {
        this.requireEnergy(MachineComponent.IOType.OUTPUT, perTick);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidInput(ILiquidStack stack) {
        this.requireFluid(MachineComponent.IOType.INPUT, stack);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFluidOutput(ILiquidStack stack) {
        this.requireFluid(MachineComponent.IOType.OUTPUT, stack);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasInput(String gasName, int amount) {
        this.requireGas(MachineComponent.IOType.INPUT, gasName, amount);
        return this;
    }

    @ZenMethod
    @Optional.Method(modid="mekanism")
    public RecipePrimer addGasOutput(String gasName, int amount) {
        this.requireGas(MachineComponent.IOType.OUTPUT, gasName, amount);
        return this;
    }

    @ZenMethod
    public RecipePrimer addItemInput(IItemStack stack) {
        this.requireItem(MachineComponent.IOType.INPUT, stack);
        return this;
    }

    @ZenMethod
    public RecipePrimer addItemInput(IOreDictEntry oreDict) {
        return this.addItemInput(oreDict, 1);
    }

    @ZenMethod
    public RecipePrimer addItemInput(IOreDictEntry oreDict, int amount) {
        this.requireItem(MachineComponent.IOType.INPUT, oreDict.getName(), amount);
        return this;
    }

    @ZenMethod
    public RecipePrimer addFuelItemInout(int requiredTotalBurnTime) {
        return this.addFuelItemInput(requiredTotalBurnTime);
    }

    @ZenMethod
    public RecipePrimer addFuelItemInput(int requiredTotalBurnTime) {
        this.requireItem(MachineComponent.IOType.INPUT, requiredTotalBurnTime);
        return this;
    }

    @ZenMethod
    public RecipePrimer addItemOutput(IItemStack stack) {
        this.requireItem(MachineComponent.IOType.OUTPUT, stack);
        return this;
    }

    @ZenMethod
    public RecipePrimer addItemOutput(IOreDictEntry oreDict) {
        return this.addItemOutput(oreDict, 1);
    }

    @ZenMethod
    public RecipePrimer addItemOutput(IOreDictEntry oreDict, int amount) {
        this.requireItem(MachineComponent.IOType.OUTPUT, oreDict.getName(), amount);
        return this;
    }

    private void requireEnergy(MachineComponent.IOType ioType, long perTick) {
        this.appendComponent(new RequirementEnergy(ioType, perTick));
    }

    private void requireFluid(MachineComponent.IOType ioType, ILiquidStack stack) {
        FluidStack mcFluid = CraftTweakerMC.getLiquidStack((ILiquidStack)stack);
        if (mcFluid == null) {
            CraftTweakerAPI.logError((String)("FluidStack not found/unknown fluid: " + stack.toString()));
            return;
        }
        if (stack.getTag() != null) {
            mcFluid.tag = CraftTweakerMC.getNBTCompound((IData)stack.getTag());
        }
        RequirementFluid rf = new RequirementFluid(ioType, mcFluid);
        this.appendComponent(rf);
    }

    @Optional.Method(modid="mekanism")
    private void requireGas(MachineComponent.IOType ioType, String gasName, int amount) {
        Gas gas = GasRegistry.getGas((String)gasName);
        if (gas == null) {
            CraftTweakerAPI.logError((String)("GasStack not found/unknown gas: " + gasName));
            return;
        }
        amount = Math.max(0, amount);
        GasStack gasStack = new GasStack(gas, amount);
        RequirementFluid req = RequirementFluid.createMekanismGasRequirement(ComponentType.Registry.COMPONENT_GAS, ioType, gasStack);
        this.appendComponent(req);
    }

    private void requireItem(MachineComponent.IOType ioType, int requiredTotalBurnTime) {
        this.appendComponent(new RequirementItem(ioType, requiredTotalBurnTime));
    }

    private void requireItem(MachineComponent.IOType ioType, IItemStack stack) {
        ItemStack mcStack = CraftTweakerMC.getItemStack((IItemStack)stack);
        if (mcStack.func_190926_b()) {
            CraftTweakerAPI.logError((String)("ItemStack not found/unknown item: " + stack.toString()));
            return;
        }
        RequirementItem ri = new RequirementItem(ioType, mcStack);
        if (stack.getTag().length() > 0) {
            ri.tag = CraftTweakerMC.getNBTCompound((IData)stack.getTag());
            ri.previewDisplayTag = CraftTweakerMC.getNBTCompound((IData)stack.getTag());
        }
        this.appendComponent(ri);
    }

    private void requireItem(MachineComponent.IOType ioType, String oreDictName, int amount) {
        this.appendComponent(new RequirementItem(ioType, oreDictName, amount));
    }

    public void appendComponent(ComponentRequirement component) {
        this.components.add(component);
        this.lastComponent = component;
    }

    @ZenMethod
    public void build() {
        RecipeRegistry.getRegistry().registerRecipeEarly(this);
    }

    @Override
    public String getFilePath() {
        return "";
    }

    @Override
    public ResourceLocation getRecipeRegistryName() {
        return this.name;
    }

    @Override
    public ResourceLocation getAssociatedMachineName() {
        return this.machineName;
    }

    @Override
    public int getTotalProcessingTickTime() {
        return this.tickTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<ComponentRequirement> getComponents() {
        return this.components;
    }
}

