/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.crafting.component;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import fr.frinn.modularmagic.common.crafting.requirement.RequirementAspect;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import thaumcraft.api.aspects.Aspect;

public class ComponentAspect
extends ComponentType<RequirementAspect> {
    @Nonnull
    public String getRegistryName() {
        return "aspect";
    }

    @Nullable
    public String requiresModid() {
        return "thaumcraft";
    }

    @Nonnull
    public RequirementAspect provideComponent(MachineComponent.IOType ioType, JsonObject requirement) {
        if (requirement.has("amount") && requirement.get("amount").isJsonPrimitive() && requirement.get("amount").getAsJsonPrimitive().isNumber()) {
            if (requirement.has("aspect") && requirement.get("aspect").isJsonPrimitive() && requirement.get("aspect").getAsJsonPrimitive().isString()) {
                int aspectRequired = requirement.getAsJsonPrimitive("amount").getAsInt();
                if (aspectRequired < 0) {
                    throw new JsonParseException("'amount' can not be less than 0");
                }
                Aspect aspect = Aspect.getAspect((String)requirement.get("aspect").getAsString());
                if (aspect != null) {
                    return new RequirementAspect(ioType, aspectRequired, aspect);
                }
                throw new JsonParseException("Invalid aspect name : " + requirement.getAsJsonPrimitive("aspect").getAsString());
            }
            throw new JsonParseException("The ComponentType '" + this.getRegistryName() + "' expects a 'aspect'-entry that defines the required/produced aspect");
        }
        throw new JsonParseException("The ComponentType '" + this.getRegistryName() + "' expects a 'amount'-entry that defines the required/produced aspect amount");
    }
}

