/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.crafting.component;

import WayofTime.bloodmagic.soul.EnumDemonWillType;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import fr.frinn.modularmagic.common.crafting.requirement.RequirementWill;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComponentWill
extends ComponentType<RequirementWill> {
    @Nonnull
    public String getRegistryName() {
        return "will";
    }

    @Nullable
    public String requiresModid() {
        return "bloodmagic";
    }

    @Nonnull
    public RequirementWill provideComponent(MachineComponent.IOType ioType, JsonObject requirement) {
        if (requirement.has("willamount") && requirement.get("willamount").isJsonPrimitive() && requirement.get("willamount").getAsJsonPrimitive().isNumber()) {
            if (requirement.has("willtype") && requirement.get("willtype").isJsonPrimitive() && requirement.get("willtype").getAsJsonPrimitive().isString()) {
                double willRequired = requirement.getAsJsonPrimitive("willamount").getAsDouble();
                if (willRequired > 100.0 || willRequired < 0.0) {
                    throw new JsonParseException("'willamount' need to be between 0 and 100");
                }
                EnumDemonWillType willtype = this.getWillType(requirement.getAsJsonPrimitive("willtype").getAsString());
                if (willtype != null) {
                    return new RequirementWill(ioType, willRequired, willtype);
                }
                throw new JsonParseException("Invalid demon will type : " + requirement.getAsJsonPrimitive("willtype").getAsString());
            }
            throw new JsonParseException("The ComponentType '" + this.getRegistryName() + "' expects a 'willtype'-entry that defines the required/produced demon will type");
        }
        throw new JsonParseException("The ComponentType '" + this.getRegistryName() + "' expects a 'willamount'-entry that defines the required/produced demon will amount");
    }

    private EnumDemonWillType getWillType(String stringWillType) {
        switch (stringWillType) {
            case "corrosive": {
                return EnumDemonWillType.CORROSIVE;
            }
            case "destructive": {
                return EnumDemonWillType.DESTRUCTIVE;
            }
            case "steadfast": {
                return EnumDemonWillType.STEADFAST;
            }
            case "vengeful": {
                return EnumDemonWillType.VENGEFUL;
            }
            case "raw": {
                return EnumDemonWillType.DEFAULT;
            }
        }
        return null;
    }
}

