/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.crafting.requirement;

import com.google.common.collect.Lists;
import fr.frinn.modularmagic.common.integration.jei.component.JEIComponentGrid;
import fr.frinn.modularmagic.common.tile.TileGridProvider;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;

public class RequirementGrid
extends ComponentRequirement {
    public float power;

    public RequirementGrid(MachineComponent.IOType actionType, float power) {
        super(ComponentType.Registry.getComponent((String)"grid"), actionType);
        this.power = power;
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        TileGridProvider provider = (TileGridProvider)((Object)component.getContainerProvider());
        if (provider == null || !this.canStartCrafting(component, context, Lists.newArrayList()).isSuccess()) {
            return false;
        }
        switch (this.getActionType()) {
            case INPUT: {
                provider.setPower(-this.power);
            }
            case OUTPUT: {
                provider.setPower(this.power);
            }
        }
        return true;
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        TileGridProvider provider = (TileGridProvider)((Object)component.getContainerProvider());
        if (provider != null) {
            provider.setPower(0.0f);
        }
        return true;
    }

    @Nonnull
    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List restrictions) {
        TileGridProvider provider = (TileGridProvider)((Object)component.getContainerProvider());
        if (provider == null) {
            return CraftCheck.failure((String)"error.modularmagic.requirement.grid.missingprovider");
        }
        if (this.getActionType() == MachineComponent.IOType.INPUT && provider.getFreq().getPowerCreated() - provider.getFreq().getPowerDrain() < this.power) {
            return CraftCheck.failure((String)"error.modularmagic.requirement.grid.less");
        }
        return CraftCheck.success();
    }

    public ComponentRequirement deepCopy() {
        return this;
    }

    public ComponentRequirement deepCopyModified(List list) {
        return this;
    }

    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    public void endRequirementCheck() {
    }

    public ComponentRequirement.JEIComponent provideJEIComponent() {
        return new JEIComponentGrid(this);
    }
}

