/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.crafting.requirement;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import com.google.common.collect.Lists;
import fr.frinn.modularmagic.common.integration.jei.component.JEIComponentLifeEssence;
import fr.frinn.modularmagic.common.tile.TileLifeEssenceProvider;
import fr.frinn.modularmagic.common.tile.machinecomponent.MachineComponentLifeEssenceProvider;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;

public class RequirementLifeEssence
extends ComponentRequirement.PerTick {
    public int essenceAmount;
    public boolean isPerTick;
    SoulNetwork network;
    private boolean flag = false;

    public RequirementLifeEssence(MachineComponent.IOType actionType, int essenceAmount, boolean perTick) {
        super(ComponentType.Registry.getComponent((String)"lifeessence"), actionType);
        this.essenceAmount = essenceAmount;
        this.isPerTick = perTick;
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        if (!this.canStartCrafting(component, context, Lists.newArrayList()).isSuccess()) {
            return false;
        }
        TileLifeEssenceProvider essenceProvider = (TileLifeEssenceProvider)((Object)component.getContainerProvider());
        this.network = essenceProvider.getSoulNetwork();
        if (this.getActionType() == MachineComponent.IOType.INPUT && !this.isPerTick) {
            essenceProvider.getSoulNetwork().syphon(new SoulTicket(this.essenceAmount));
        }
        return true;
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        if (this.getActionType() == MachineComponent.IOType.OUTPUT && !this.isPerTick) {
            TileLifeEssenceProvider essenceProvider = (TileLifeEssenceProvider)((Object)component.getContainerProvider());
            essenceProvider.getSoulNetwork().add(new SoulTicket(this.essenceAmount), essenceProvider.getOrbCapacity());
        }
        return true;
    }

    @Nonnull
    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List restrictions) {
        if (!component.getComponentType().equals((Object)this.getRequiredComponentType()) || !(component instanceof MachineComponentLifeEssenceProvider) || component.getIOType() != this.getActionType()) {
            return CraftCheck.skipComponent();
        }
        TileLifeEssenceProvider essenceProvider = (TileLifeEssenceProvider)((Object)component.getContainerProvider());
        if (essenceProvider.getSoulNetwork() == null) {
            return CraftCheck.failure((String)"error.modularmagic.requirement.lifeessence.orb");
        }
        switch (this.getActionType()) {
            case INPUT: {
                if (essenceProvider.getSoulNetwork().getCurrentEssence() >= this.essenceAmount) {
                    return CraftCheck.success();
                }
                return CraftCheck.failure((String)"error.modularmagic.requirement.lifeessence.lp");
            }
            case OUTPUT: {
                return CraftCheck.success();
            }
        }
        return CraftCheck.failure((String)"error.modularmagic.requirement.lifeessence");
    }

    public void startIOTick(RecipeCraftingContext context, float durationMultiplier) {
        this.flag = false;
    }

    @Nonnull
    public CraftCheck resetIOTick(RecipeCraftingContext context) {
        if (!this.isPerTick || this.network.getCurrentEssence() >= this.essenceAmount || this.flag) {
            return CraftCheck.success();
        }
        return CraftCheck.failure((String)"error.modularmagic.requirement.lifeessence.lp");
    }

    @Nonnull
    public CraftCheck doIOTick(MachineComponent component, RecipeCraftingContext context) {
        if (this.isPerTick) {
            TileLifeEssenceProvider essenceProvider = (TileLifeEssenceProvider)((Object)component.getContainerProvider());
            switch (this.getActionType()) {
                case INPUT: {
                    if (essenceProvider.getSoulNetwork().getCurrentEssence() >= this.essenceAmount) {
                        essenceProvider.getSoulNetwork().syphon(new SoulTicket(this.essenceAmount));
                        this.flag = true;
                        return CraftCheck.success();
                    }
                    this.flag = false;
                    return CraftCheck.failure((String)"error.modularmagic.requirement.lifeessence.lp");
                }
                case OUTPUT: {
                    essenceProvider.getSoulNetwork().add(new SoulTicket(this.essenceAmount), essenceProvider.getOrbCapacity());
                    this.flag = true;
                    return CraftCheck.success();
                }
            }
        }
        return CraftCheck.skipComponent();
    }

    public ComponentRequirement deepCopy() {
        return this;
    }

    public ComponentRequirement deepCopyModified(List list) {
        return this;
    }

    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    public void endRequirementCheck() {
    }

    public ComponentRequirement.JEIComponent provideJEIComponent() {
        return new JEIComponentLifeEssence(this);
    }
}

