/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.modularmagic.common.crafting.requirement;

import com.google.common.collect.Lists;
import fr.frinn.modularmagic.common.integration.jei.component.JEIComponentStarlight;
import fr.frinn.modularmagic.common.tile.TileStarlightInput;
import fr.frinn.modularmagic.common.tile.TileStarlightOutput;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;

public class RequirementStarlight
extends ComponentRequirement {
    public float starlightAmount;

    public RequirementStarlight(MachineComponent.IOType actionType, float starlightAmount) {
        super(ComponentType.Registry.getComponent((String)"starlight"), actionType);
        this.starlightAmount = starlightAmount;
    }

    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        return this.canStartCrafting(component, context, Lists.newArrayList()).isSuccess();
    }

    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        if (this.getActionType() == MachineComponent.IOType.OUTPUT) {
            ((TileStarlightOutput)((Object)component.getContainerProvider())).setStarlightProduced(0.0f);
        }
        return true;
    }

    @Nonnull
    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List restrictions) {
        if (component.getContainerProvider() instanceof TileStarlightInput || component.getContainerProvider() instanceof TileStarlightOutput) {
            if (this.getActionType() == MachineComponent.IOType.INPUT) {
                TileStarlightInput provider = (TileStarlightInput)((Object)component.getContainerProvider());
                return (float)provider.getStarlightStored() >= this.starlightAmount ? CraftCheck.success() : CraftCheck.failure((String)"error.modularmagic.requirement.starlight.less");
            }
            if (this.getActionType() == MachineComponent.IOType.OUTPUT) {
                TileStarlightOutput provider = (TileStarlightOutput)((Object)component.getContainerProvider());
                provider.setStarlightProduced(this.starlightAmount / 4000.0f);
                provider.controller = context.getMachineController();
                return CraftCheck.success();
            }
            return CraftCheck.failure((String)"error.modularmagic.requirement.invalid");
        }
        return CraftCheck.failure((String)"error.modularmagic.requirement.starlight.missingprovider");
    }

    public ComponentRequirement deepCopy() {
        return this;
    }

    public ComponentRequirement deepCopyModified(List list) {
        return this;
    }

    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    public void endRequirementCheck() {
    }

    public ComponentRequirement.JEIComponent provideJEIComponent() {
        return new JEIComponentStarlight(this);
    }
}

