/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mpbasic.commands;

import com.gendeathrow.mpbasic.configs.NotificationsConfigs;
import com.gendeathrow.mputils.commands.MP_BaseCommand;
import com.gendeathrow.mputils.commands.common.MP_Commands;
import com.gendeathrow.mputils.core.MPUtils;
import com.gendeathrow.mputils.network.ScreenNotificationPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SendOnScreenNoticeCommand
extends MP_BaseCommand {
    public static void register() {
        MP_Commands.registerCmd((MP_BaseCommand)new SendOnScreenNoticeCommand());
    }

    public String getCommand() {
        return "notify";
    }

    public String getUsageSuffix() {
        return "/mpa notify <playerName> <onscreen notification id>";
    }

    public boolean validArgs(String[] args) {
        return args.length >= 3;
    }

    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 2) {
            return MP_Commands.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 3) {
            for (Map.Entry<String, NotificationsConfigs.NotificationObject> page : NotificationsConfigs.LoadedNotifications.entrySet()) {
                list.add(page.getKey());
            }
            MP_Commands.func_175762_a((String[])args, list);
        }
        return list;
    }

    public void runCommand(CommandBase command, MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException(this.getUsageSuffix(), new Object[0]);
        }
        EntityPlayerMP entityplayer = MP_Commands.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
        if (NotificationsConfigs.LoadedNotifications.containsKey(args[2])) {
            NotificationsConfigs.NotificationObject notify = NotificationsConfigs.LoadedNotifications.get(args[2]);
            if (sender.func_174793_f() instanceof EntityPlayerMP) {
                MPUtils.network.sendTo((IMessage)new ScreenNotificationPacket(notify.lines, notify.soundLocation, notify.bgColor, notify.borderColor), (EntityPlayerMP)sender.func_174793_f());
            }
        } else {
            throw new WrongUsageException("Error with " + args[2] + " || " + this.getUsageSuffix(), new Object[0]);
        }
    }
}

