/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.model.block;

import epicsquid.mysticallib.model.CustomModelBase;
import epicsquid.mysticallib.model.ModelUtil;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.parts.Cube;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class BakedModelTrapDoor
extends BakedModelBlock {
    private Cube cube_down;
    private Cube cube_up;
    private Cube cube_east;
    private Cube cube_west;
    private Cube cube_south;
    private Cube cube_north;

    public BakedModelTrapDoor(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, @Nonnull CustomModelBase model) {
        super(format, bakedTextureGetter, model);
        TextureAtlasSprite[] texes = new TextureAtlasSprite[]{this.texwest, this.texeast, this.texdown, this.texup, this.texnorth, this.texsouth};
        this.cube_down = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 1.0, 0.1875, 1.0, null, texes, 0).setNoCull(EnumFacing.DOWN);
        this.cube_up = ModelUtil.makeCube(format, 0.0, 0.8125, 0.0, 1.0, 0.1875, 1.0, null, texes, 0).setNoCull(EnumFacing.UP);
        this.cube_west = ModelUtil.makeCube(format, 0.8125, 0.0, 0.0, 0.1875, 1.0, 1.0, null, texes, 0).setNoCull(EnumFacing.WEST);
        this.cube_east = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 0.1875, 1.0, 1.0, null, texes, 0).setNoCull(EnumFacing.EAST);
        this.cube_north = ModelUtil.makeCube(format, 0.0, 0.0, 0.8125, 1.0, 1.0, 0.1875, null, texes, 0).setNoCull(EnumFacing.NORTH);
        this.cube_south = ModelUtil.makeCube(format, 0.0, 0.0, 0.0, 1.0, 1.0, 0.1875, null, texes, 0).setNoCull(EnumFacing.SOUTH);
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.getFaceQuads(quads, side, state);
        return quads;
    }

    private void getFaceQuads(@Nonnull List<BakedQuad> quads, @Nullable EnumFacing side, @Nullable IBlockState state) {
        if (state == null) {
            this.cube_down.addToList(quads, side);
        } else {
            BlockTrapDoor.DoorHalf half = (BlockTrapDoor.DoorHalf)state.func_177229_b((IProperty)BlockTrapDoor.field_176285_M);
            boolean open = (Boolean)state.func_177229_b((IProperty)BlockTrapDoor.field_176283_b);
            if (!open) {
                if (half == BlockTrapDoor.DoorHalf.BOTTOM) {
                    this.cube_down.addToList(quads, side);
                } else {
                    this.cube_up.addToList(quads, side);
                }
            } else {
                switch ((EnumFacing)state.func_177229_b((IProperty)BlockTrapDoor.field_176284_a)) {
                    case EAST: {
                        this.cube_east.addToList(quads, side);
                        break;
                    }
                    case SOUTH: {
                        this.cube_south.addToList(quads, side);
                        break;
                    }
                    case WEST: {
                        this.cube_west.addToList(quads, side);
                        break;
                    }
                    case NORTH: {
                        this.cube_north.addToList(quads, side);
                    }
                }
            }
        }
    }
}

